import unittest
import os
import mx.DateTime
import baseclass

import jppy
from jppy.printers import contact_printer, contact_label, todos_printer

class todosPrinterTest(baseclass.baseTest):
    def runTest(self):
        pass

class contactPrinterTest(baseclass.baseTest):
    def runTest(self):
        ab = jppy.jpilot.modern.addressBook(self.env)
        contact = ab.new()
        contact['firstname'] = "Jack"
        contact['lastname'] = "Brown"
        contact['zip1'] = "NG12 1BX"
        contact['phone1'] = "at-home-12345"
        contact['type1'] = ab.getPhoneLabels().index('Home')
        contact['phone2'] = "there@somewhere.com"
        contact['type2'] = ab.getPhoneLabels().index('Email')
        contact.log("This is a test log entry")
        contact.category = 2
        filename = contact_printer(self.env).render(ab,contact)
        self.assertEqual(os.path.isfile(filename),1)
        #os.system("acroread %s" % filename)
        
        if os.path.getsize(filename) < 100:
            self.fail("PDF is less than 100 bytes, which is likely broken.")
        os.unlink(filename)
        self.assertEqual(os.path.isfile(filename),0)

class todosPrinterTest(baseclass.baseTest):
    def runTest(self):
        tasklist = self.env.taskList
        for i in range(0,10):
            t = tasklist.new()
            t['description'] = "Todo item %d" % i
            t['due'] = mx.DateTime.now() + i
            t['priority'] = 3
            tasklist.save(t)
        todos = tasklist.records()
        filename = todos_printer(self.env).render(tasklist, todos)
        self.assertEqual(os.path.isfile(filename),1)
        #os.system("acroread %s" % filename)        
        if os.path.getsize(filename) < 100:
            self.fail("PDF is less than 100 bytes, which is likely broken.")
        os.unlink(filename)
        self.assertEqual(os.path.isfile(filename),0)

def suite():
    suite  = unittest.TestSuite()
    suite.addTest(contactPrinterTest())
    suite.addTest(todosPrinterTest())    
    return suite




