/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.OutputStream;

final class FieldsWriter {
    private FieldInfos fieldInfos;
    private OutputStream fieldsStream;
    private OutputStream indexStream;

    FieldsWriter(Directory d, String segment, FieldInfos fn) throws IOException {
        this.fieldInfos = fn;
        this.fieldsStream = d.createFile(segment + ".fdt");
        this.indexStream = d.createFile(segment + ".fdx");
    }

    final void close() throws IOException {
        this.fieldsStream.close();
        this.indexStream.close();
    }

    final void addDocument(Document doc) throws IOException {
        Field field;
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        int storedCount = 0;
        Enumeration fields = doc.fields();
        while (fields.hasMoreElements()) {
            field = (Field)fields.nextElement();
            if (!field.isStored()) continue;
            ++storedCount;
        }
        this.fieldsStream.writeVInt(storedCount);
        fields = doc.fields();
        while (fields.hasMoreElements()) {
            field = (Field)fields.nextElement();
            if (!field.isStored()) continue;
            this.fieldsStream.writeVInt(this.fieldInfos.fieldNumber(field.name()));
            byte bits = 0;
            if (field.isTokenized()) {
                bits = (byte)(bits | 1);
            }
            this.fieldsStream.writeByte(bits);
            this.fieldsStream.writeString(field.stringValue());
        }
    }
}

