
/*
 * describe.c -- written for Juice
 *  Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define _GNU_SOURCE			 /* snprintf() */

#include <stdio.h>			 /* snprintf() */
#include <string.h>			 /* strncpy(), strcpy(), strrchr(), strcspn(), strlen(), strcmp(), strspn(), strstr() */
#include <stdlib.h>			 /* NULL */
#include <sys/types.h>		 /* open(), O_RDONLY */
#include <sys/stat.h>		 /* open(), O_RDONLY */
#include <fcntl.h>			 /* open(), O_RDONLY */
#include <unistd.h>			 /* close() */

#include "typedefs.h"							 /* bool, TRUE, FALSE */
#include "utils.h"								 /* fperm(), readline(), trim() */
#include "describe.h"							 /* song_t, FIELDLEN */

/*
 * Extract information from a 4dos-like descript.ion file
 * in the directory in which filename resides, if possible.
 * A normal 4dos description file will pass, but it is
 * recommended that you put a header at the top of the
 * form <artist> <delim> <album> where <delim> can be either
 * a ':' or a '-'. If there is no artist (or multiple ones),
 * just put the album name in the header. In the case of
 * multiple artists, it can be included with each song.
 * If describe() returns TRUE, the song info was extracted
 * succesfully and put in song, FALSE if not successful.
 *
 * UPDATE:
 *  All TAB's found in the descript.ion file will be converted
 *  to spaces when read. Therefore, don't use TABs in
 *  descript.ion's
 */
bool describe (song_t *song,const char *filename)
{
   char line[256],desc[256],dir[256],*file,str1[256],str2[256];
   int i,fd;
   bool header = FALSE;
   /* Split filename into it's directory and file */
   dir[255] = '\0';
   strncpy (dir,filename,256);
   if (dir[255] != '\0') return FALSE;
   if ((file = strrchr (dir,'/')) != NULL) *file = '\0', file++; else *dir = '\0', file = (char *) filename;
   /* This is our description file */
   if (snprintf (desc,sizeof (desc) - 1,"%s%sdescript.ion",dir,*dir != '\0' ? "/" : "") < 0) return FALSE;
   /* Make sure it's a regular file and that we have the necessary permissions to read it */
   if (!fperm (desc,"r","r")) return FALSE;
   /* Open description file for reading */
   if ((fd = open (desc,O_RDONLY)) < 0) return FALSE;
   while (readline (fd,line,sizeof (line) - 1) >= 0)
	 {
		/* First remove carriage returns ('\r') in case it's a DOS file */
		for (i = 0; i < (int) strlen (line); i++) if (line[i] == '\r') line[i] = ' ';
		if (!header)
		  {
			 /* Is this the song we're looking for? */
			 strcpy (str1,line);
			 i = strcspn (line,"\t ");
			 str1[i] = '\0';
			 for (i = 0; i < (int) strlen (str1); i++) if (str1[i] == '\n') str1[i] = ' ';
			 trim (str1);
			 if (strcmp (file,str1) == 0)
			   {
				  /* It is, so we don't have a header */
				  i += strspn (line + i,"\t ");
				  strcpy (line,line + i);
				  /* Extract the info */
				  strcpy (str1,line);
				  i = strcspn (line,"\n");
				  str1[i] = '\0';
				  trim (str1);
				  song->album[0] = song->artist[0] = '\0';
				  if (*str1 == '\0')
					{
					   close (fd);
					   return FALSE;
					}
				  song->title[FIELDLEN] = '\0';
				  strncpy (song->title,str1,FIELDLEN);
				  for (i = 0; i < (int) strlen (song->title); i++) if (song->title[i] == '\t') song->title[i] = ' ';
				  close (fd);
				  return TRUE;
			   }
			 /* Get the album and artist */
			 strcpy (str1,line);
			 i = strcspn (line,":-");
			 str1[i] = '\0';
			 for (i = 0; i < (int) strlen (str1); i++) if (str1[i] == '\n') str1[i] = ' ';
			 trim (str1);
			 if (*str1 == '\0') continue;
			 i += strspn (line + i,":-");
			 strcpy (str2,line + i);
			 i = strcspn (str2,"\n");
			 str2[i] = '\0';
			 trim (str2);
			 song->album[FIELDLEN] = song->artist[FIELDLEN] = '\0';
			 if (strstr (str1,".mp3") != NULL)
			   {
				  /* We're already past the header (because there is no header) */
				  song->album[0] = song->artist[0] = '\0';
			   }
			 else if (*str2 != '\0')
			   {
				  strncpy (song->artist,str1,FIELDLEN);
				  strncpy (song->album,str2,FIELDLEN);
				  for (i = 0; i < (int) strlen (song->artist); i++) if (song->artist[i] == '\t') song->artist[i] = ' ';
				  for (i = 0; i < (int) strlen (song->album); i++) if (song->album[i] == '\t') song->album[i] = ' ';
			   }
			 else
			   {
				  strncpy (song->album,str1,FIELDLEN);
				  song->artist[0] = '\0';
				  for (i = 0; i < (int) strlen (song->album); i++) if (song->album[i] == '\t') song->album[i] = ' ';
			   }
			 header = TRUE;
		  }
		else
		  {
			 /* Is this the song we're looking for? */
			 strcpy (str1,line);
			 i = strcspn (line,"\t ");
			 str1[i] = '\0';
			 for (i = 0; i < (int) strlen (str1); i++) if (str1[i] == '\n') str1[i] = ' ';
			 trim (str1);
			 if (strcmp (file,str1) != 0) continue;
			 i += strspn (line + i,"\t ");
			 strcpy (line,line + i);
			 /* Ok it is, so we extract the info */
			 strcpy (str1,line);
			 i = strcspn (line,"\n");
			 str1[i] = '\0';
			 trim (str1);
			 if (*str1 == '\0')
			   {
				  close (fd);
				  return FALSE;
			   }
			 song->title[FIELDLEN] = '\0';
			 strncpy (song->title,str1,FIELDLEN);
			 for (i = 0; i < (int) strlen (song->title); i++) if (song->title[i] == '\t') song->title[i] = ' ';
			 close (fd);
			 return TRUE;
		  }
	 }
   close (fd);
   return FALSE;
}

