#ifndef K3DSDK_IOBJECT_H
#define K3DSDK_IOBJECT_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares iobject, the abstract interface which MUST be implemented by ALL K-3D objects
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iunknown.h"
#include "signal_system.h"

#include <string>

// Forward declarations
class k3dIState;

namespace k3d
{

// Forward declarations
class idocument;
class iplugin_factory;

/////////////////////////////////////////////////////////////////////////////
// iobject

/// Abstract interface which MUST be implemented by ALL K-3D document objects
class iobject :
	public virtual iunknown
{
public:
	/// Defines a unique identifier that can be serialized
	typedef unsigned long id_type;
	/// Returns a unique identifier for this object that can be serialized
	virtual const id_type id() = 0;

	/// Sets the object ID; note  ... this will only be called when importing / pasting objects
	virtual void set_id(const id_type ID) = 0;

	/// Sets the object name (could fail or be overridden)
	virtual void set_name(const std::string Name) = 0;
	/// Returns the object name
	virtual const std::string name() = 0;

	/// Returns a reference to the document that owns this object
	virtual idocument& document() = 0;
	/// Returns a reference to the factory that created this object
	virtual iplugin_factory& factory() = 0;

	/// Defines a signal that will be emitted iff the object is deleted
	typedef SigC::Signal0<void> deleted_signal_t;
	virtual deleted_signal_t& deleted_signal() = 0;

	/// Defines a signal that will be emitted if the object name changes (including via undo / redo)
	typedef SigC::Signal0<void> name_changed_signal_t;
	virtual name_changed_signal_t& name_changed_signal() = 0;

	/// Defines a signal that will be emitted if the object visibility state changes (including via undo / redo)
	/** \deprecated */
	typedef SigC::Signal0<void> visibility_changed_signal_t;
	virtual visibility_changed_signal_t& visibility_changed_signal() = 0;

protected:
	iobject() {}
	iobject(const iobject& RHS) {}
	iobject& operator=(const iobject& RHS) { return *this; }
	virtual ~iobject() {}
};

} // namespace k3d

#endif // !K3DSDK_IOBJECT_H

