#ifndef K3DSDK_MODULE_PRIVATE_H
#define K3DSDK_MODULE_PRIVATE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares detail
		\author Tim Shead (tshead@k-3d.com)
*/

#include <string>
#include "uuid.h"

namespace k3d
{

namespace detail
{

/////////////////////////////////////////////////////////////////////////////
// plugin_factory

class plugin_factory :
	public iplugin_factory
{
public:
	plugin_factory(const uuid& ClassID, const std::string Name, const std::string ShortDescription, const std::string DefaultCategory, const quality_t Quality);

	const uuid& class_id();
	const std::string name();
	const std::string short_description();
	const std::string default_category();
	quality_t quality();

private:
	const uuid m_class_id;
	const std::string m_name;
	const std::string m_short_description;
	const std::string m_default_category;
	const quality_t m_quality;
};

} // namespace detail

} // namespace k3d

#endif // !K3DSDK_MODULE_PRIVATE_H


