#ifndef K3DSDK_SERIALIZATION_H
#define K3DSDK_SERIALIZATION_H

// Forward declarations
namespace sdpxml { class Element; }

// Forward declarations
namespace boost { namespace filesystem { class path; } }

namespace k3d
{

// Forward declarations
class idocument;
class igeometry_read_format;
class igeometry_write_format;

/// Serializes a document DAG to an XML document
void save_dag(idocument& Document, sdpxml::Element& XML);
/// Deserializes document DAG information from an XML document
void load_dag(idocument& Document, sdpxml::Element& XML);

/// Imports data into a document from a file
bool import_file(idocument& Document, igeometry_read_format& FormatFilter, const boost::filesystem::path& FilePath);
/// Exports document data to a file
bool export_file(idocument& Document, igeometry_write_format& FormatFilter, const boost::filesystem::path& FilePath);

} // namespace k3d

#endif // !K3DSDK_SERIALIZATION_H
