#ifndef K3DSDK_USER_INTERFACE_H
#define K3DSDK_USER_INTERFACE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Timothy M. Shead (tshead@k-3d.com)
*/

#include <string>

// Forward declarations
namespace boost { namespace filesystem { class path; } }

namespace k3d
{

/// Convenience wrapper for calls to k3d::iuser_interface::message()
void message(const std::string& Message, const std::string& Title);
/// Convenience wrapper for calls to k3d::iuser_interface::error_message()
void error_message(const std::string& Message, const std::string& Title);
/// Convenience wrapper for calls to k3d::iuser_interface::query_message()
unsigned int query_message(const std::string& Message, const std::string& Title, const unsigned int DefaultButton, const std::vector<std::string> Buttons);
/// Convenience wrapper for calls to k3d::iuser_interface::get_file_path()
bool get_file_path(const std::string& Type, const std::string& Prompt, const bool PromptOverwrite, const boost::filesystem::path& OldPath, boost::filesystem::path& Result);

} // namespace k3d

#endif // K3DSDK_USER_INTERFACE_H

