#ifndef K3DUI_SCRIPT_EDITOR_H
#define K3DUI_SCRIPT_EDITOR_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the script_editor class, which provides a UI for editing / executing scripts
		\author Tim Shead (tshead@k-3d.com)
*/

#include "text_editors.h"

namespace k3d
{

// Forward declarations
class iproperty;

/////////////////////////////////////////////////////////////////////////////
// script_editor

/// Provides a standard user interface for editing file-based scripts
class script_editor :
	public k3dScriptEditor
{
	typedef k3dScriptEditor base;
	
public:
	script_editor(k3d::icommand_node& Parent);

private:
	/// Called by the signal system when the application is closed
	void on_application_closed();
};

/////////////////////////////////////////////////////////////////////////////
// inline_script_editor

/// Provides a standard user interface for editing in-memory scripts
void display_inline_script_editor(iproperty& Script, icommand_node& Parent, const std::string& ScriptName);

} // namespace k3d

#endif // K3DUI_SCRIPT_EDITOR_H
