#ifndef K3DUI_VIEWPORT_CONTROL_H
#define K3DUI_VIEWPORT_CONTROL_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/ianimation_render_engine.h>
#include <k3dsdk/istill_render_engine.h>
#include <k3dsdk/signal_system.h>

// Forward declarations
class sdpGtkWidget;

namespace k3d
{

// Forward declarations
class idocument;
class iunknown;
class iviewport;

namespace viewport
{

class control :
	public k3d::ianimation_render_engine,
	public k3d::istill_render_engine
{
public:
	control(idocument& Document, iunknown& ParentCommandNode, const sdpGtkWidget& Owner);
	~control();
	
	/// Attaches the control to a viewport (may be called multiple times)
	bool attach(iviewport& Viewport);

	/// Defines a signal for notifying observers if the viewport changes
	typedef SigC::Signal1<void, iviewport*> viewport_changed_signal_t;
	viewport_changed_signal_t& viewport_changed_signal();

	bool render_preview();
	bool render_frame(const boost::filesystem::path& OutputImage, const bool ViewCompletedImage);
	bool render_animation(const boost::filesystem::path& OutputImages, const bool ViewCompletedImages);

private:
	class implementation;
	implementation* const m_implementation;

	control(const control&);
};

} // namespace viewport

} // namespace k3d

#endif // !K3DUI_VIEWPORT_CONTROL_H


