#ifndef SDPGL_PLATFORM_H
#define SDPGL_PLATFORM_H

// SDPGL
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

/////////////////////////////////////////////////////////////////////////////
// Compiler vendors

#if defined _MSC_VER		// Microsoft compiler
/// Compiler is Microsoft Visual C++
#define SDPGL_MICROSOFT
#elif defined __BCPLUSPLUS__	// Borland compiler
/// Compiler is Borland
#define SDPGL_BORLAND
#elif defined(__MINGW32__) || defined (__CYGWIN__)	// GNU C Win32 compiler
//  Compiler GNU C MinGW 32
#define SDPGL_MINGW32
#else				// Unknown compiler
#endif

/////////////////////////////////////////////////////////////////////////////
// Operating systems

#if defined WIN32
/// target platform is Win32
#define SDPGL_WIN32
#else // !WIN32
/// Target platform is Posix
#define SDPGL_POSIX
#endif //  !WIN32

#endif // !SDPGL_PLATFORM_H

