#include <k3dsdk/version.h>
#include <iostream>

extern "C"
{
#include <Python.h>
}

#if defined K3D_PLATFORM_DARWIN
	#define PYTHON_INITIALIZE PyMac_Initialize
#else
	#define PYTHON_INITIALIZE Py_Initialize
#endif

#define PYVAL_NONE Py_BuildValue("")

PyObject* python_wrap(const std::string& Value)
{
	return Py_BuildValue("s", const_cast<char*>(Value.c_str()));
}

////////////////////////////////////////////////////////////////////////////////////////
// This version of the test duplicates current engine design and crashes

#if 0

PyObject* init_object_model();

class initialize_python
{
public:
	initialize_python()
	{
		if(!Py_IsInitialized())
			PYTHON_INITIALIZE();
	}
};

class swap_thread_state
{
public:
	swap_thread_state(PyThreadState* const NewState) :
		old_state(PyThreadState_Get())
	{
		PyThreadState_Swap(NewState);
	}

	~swap_thread_state()
	{
		PyThreadState_Swap(old_state);
	}

private:
	PyThreadState* const old_state;
};

class engine
{
public:
	engine() :
		m_interpreter(Py_NewInterpreter()),
		m_module(0)
	{
	}

	~engine()
	{
		swap_thread_state thread_state(m_interpreter);
		Py_EndInterpreter(m_interpreter);
	}

	void execute(const std::string& Script, const std::string& State)
	{
		swap_thread_state thread_state(m_interpreter);

		if(!m_module)
			m_module = init_object_model();

		PyModule_AddObject(m_module, "context", python_wrap(State));
		PyRun_SimpleString(const_cast<char*>(Script.c_str()));
	}

private:
	initialize_python m_initialize_python;
	PyThreadState* m_interpreter;
	PyObject* m_module;
};

PyObject* k3d_module_test3(PyObject* self, PyObject* args)
{
	std::cerr << "entering " << __PRETTY_FUNCTION__ << std::endl;
	std::cerr << "exiting " << __PRETTY_FUNCTION__ << std::endl;
	return PYVAL_NONE;
}

PyObject* k3d_module_test2(PyObject* self, PyObject* args)
{
	std::cerr << "entering " << __PRETTY_FUNCTION__ << std::endl;
	engine e;
	e.execute("import k3d\nk3d.test3()\nprint k3d.context\n", "test3 state");
	std::cerr << "exiting " << __PRETTY_FUNCTION__ << std::endl;

	return PYVAL_NONE;
}

PyObject* k3d_module_test(PyObject* self, PyObject* args)
{
	std::cerr << "entering " << __PRETTY_FUNCTION__ << std::endl;
	engine e;
	e.execute("import k3d\nk3d.test2()\nprint k3d.context\n", "test2 state");
	std::cerr << "exiting " << __PRETTY_FUNCTION__ << std::endl;

	return PYVAL_NONE;
}

PyMethodDef k3d_module_methods[] =
{
	{"test", k3d_module_test, METH_VARARGS, "Test function"},
	{"test2", k3d_module_test2, METH_VARARGS, "Test function"},
	{"test3", k3d_module_test3, METH_VARARGS, "Test function"},
	{ NULL }
};

PyObject* init_object_model()
{
	return Py_InitModule3("k3d", k3d_module_methods, "K-3D Integration Module");
}

int main(int argc, char* argv[])
{
	engine e;
	e.execute("import k3d\nk3d.test()\nprint k3d.context\n", "test state");
}

#endif

///////////////////////////////////////////////////////////////////////////////////
// This version of the test executes fine, but everything's global -
// the context for ecah "parent" function gets overwritten by its "child" function

#if 1

PyObject* init_module();

void execute_script(const std::string& Script, const std::string& Context)
{
	init_module();

	PyObject* const main_module = PyImport_AddModule("__main__");
	PyObject* const global_dict = PyObject_GetAttrString(main_module, "__dict__");
	
	PyObject* const local_dict = PyDict_New();
	PyDict_SetItemString(local_dict, "context", python_wrap(Context));
	
	PyRun_String(const_cast<char*>(Script.c_str()), Py_file_input, global_dict, local_dict);

	Py_DECREF(local_dict);	
}

PyObject* k3d_module_test3(PyObject* self, PyObject* args)
{
	std::cerr << "entering " << __PRETTY_FUNCTION__ << std::endl;
	std::cerr << "exiting " << __PRETTY_FUNCTION__ << std::endl;

	return PYVAL_NONE;
}

PyObject* k3d_module_test2(PyObject* self, PyObject* args)
{
	std::cerr << "entering " << __PRETTY_FUNCTION__ << std::endl;
	execute_script("print context\nimport k3d\nk3d.test3()\nprint context\n", "test3 context");
	std::cerr << "exiting " << __PRETTY_FUNCTION__ << std::endl;
	
	return PYVAL_NONE;
}

PyObject* k3d_module_test(PyObject* self, PyObject* args)
{
	std::cerr << "entering " << __PRETTY_FUNCTION__ << std::endl;
	execute_script("print context\nimport k3d\nk3d.test2()\nprint context\n", "test2 context");
	std::cerr << "exiting " << __PRETTY_FUNCTION__ << std::endl;

	return PYVAL_NONE;
}

PyMethodDef k3d_module_methods[] =
{
	{"test", k3d_module_test, METH_VARARGS, "Test function"},
	{"test2", k3d_module_test2, METH_VARARGS, "Test function"},
	{"test3", k3d_module_test3, METH_VARARGS, "Test function"},
	{ NULL }
};

PyObject* init_module()
{
	static PyObject* module = 0;
	if(!module)
		module = Py_InitModule3("k3d", k3d_module_methods, "K-3D Integration Module");
	return module;
}

int main(int argc, char* argv[])
{
	PYTHON_INITIALIZE();
	execute_script("print context\nimport k3d\nk3d.test()\nprint context\n", "test context");
	Py_Finalize();
	
	return 0;
}

#endif

