#!/usr/bin/perl

# Checks that all .cpp files are present in the .cbp XML file.
# Checks current directory only.

my @cpp_files = `ls *.cpp`;

my $cbp = `find . -maxdepth 1 -name "*.cbp"`;
chomp $cbp;
print "Checking $cbp project file.\n";
$cbp = LoadFile($cbp);


foreach my $file (@cpp_files)
{
	chomp $file;
	if($cbp !~ /filename\s*=\s*"$file"/)
	{
		print "Add $file\n";
	}
}



sub	LoadFile
{
	my ($filename) = @_;

	my $content = '';

	if(!open FH, "<$filename")
		{
			return $content;
		}

	while(<FH>)
		{
			$content .= $_;
		}

	close FH;

	return $content;
}



