#!/bin/sh 
 
# Authorzy: 
# Korneliusz 'Bastion' Jarzebki (nailz@o2.pl) 
# Aleksander 'sasza/pinkworm' Wojdyga (pinkworm@alan.umcs.lublin.pl) 
# 
# Changelog : 
# 
# 2 kwiecien 2005 v1.2 (Bastion) 
#  - Skrypt wykrywa czy jest uruchomiona przegladarka Firefox 
# 
# 31 marzec 2005 v1.1 (sasza) 
#  - Obsluga starszych wersji Firefoxa
# 
# 25 marzec 2005 v1.0 (Bastion) 
#  - Pierwsze wydanie 

NIA=`echo $* | grep -e 'noninteractive'`
 
function get_input 
{ 
    local output 
    
    echo -n "${1} " >&2 
    read output 

    echo $output 
}

if test -f $HOME/.mozilla/firefox/profiles.ini 
   then 
       echo "Wykryto przegladarke Firefox" 
       PROFILE=`cat $HOME/.mozilla/firefox/profiles.ini | grep -i Path= | head -n 1 | cut -d "=" -f2` 
       if [ $PROFILE = "" ] 
       then 
               echo 'Brak profilu w Firefoxie' 
               exit 2 
       fi 
       if [ `echo $PROFILE | head -c 1` = "/" ] 
         then 
           PROFILE_PATH=$PROFILE/prefs.js 
           LOCK_PATH=$PROFILE/lock 
         else 
           PROFILE_PATH=$HOME/.mozilla/firefox/$PROFILE/prefs.js 
           LOCK_PATH=$HOME/.mozilla/firefox/$PROFILE/lock 
       fi 
       isloop=yes 
       while [ ! -z "$isloop" ]; do 
         if test -h $LOCK_PATH 
           then 
             echo 
             echo 'Uwaga! Przegladarka Firefox jest uruchomiona.' 
             echo 'Zaleca sie zamkniecie przegladarki Firefox przed instalacja protokolu gg://' 
             if [ "$NIA" = "noninteractive" ]	
               then
                 exit 3
             fi
             getyn="$(get_input '  -->  Czy kontynuowac mimo to ? ([T]ak / [N]ie / [P]onow) ')" 
             if [ "$(echo $getyn | grep -i 't')" ]; then unset isloop; fi 
             if [ "$(echo $getyn | grep -i 'n')" ]; then exit 2; fi 
           else 
             unset isloop 
         fi 
       done 
       if [ `cat $PROFILE_PATH | grep -i -c network.protocol-handler.app.gg` -eq 0 ] 
         then 
           SCRIPT=$(dirname `which $0`)'/kadu-gg-handler.sh' 
           echo 'user_pref("network.protocol-handler.app.gg", "'$SCRIPT'");' >> $PROFILE_PATH 
           echo 'user_pref("network.protocol-handler.expose.gg", false);' >> $PROFILE_PATH 
           echo 'user_pref("network.protocol-handler.external.gg", true);' >> $PROFILE_PATH 
           echo 'user_pref("network.protocol-handler.warn-external.gg", false);' >> $PROFILE_PATH 
           echo "Przegladarka Firefox zostala skonfigurowana" 
           exit 0 
         else 
           echo "Przegladarka Firefox jest juz skonfigurowana" 
           exit 0 
         fi 
   else 
       echo "Nie wykryto przegladarki Firefox." 
       exit 1 
   fi
