/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WEATHER_H
#define WEATHER_H

#include <qobject.h>

#include "config_file.h"
#include "configuration_aware_object.h"
#include "userbox.h"
#include "autodownloader.h"

class QListViewItem;
class WeatherCfgUiHandler;

/**
	Gwna klasa moduu, obsuga menu oraz konfiguracji.
**/
class Weather : public QObject, ConfigurationAwareObject
{
	Q_OBJECT
	
	public:
		Weather();
		~Weather();
		
	private:
		WeatherCfgUiHandler* cfgHandler_;
		AutoDownloader autoDownloader_;
		int menuMyWeather_;
		int menuWeatherFor_;
		bool menuShowContactWeather_;
		
		virtual void configurationUpdated();
		
	private slots:
		void ShowWeather();
		void ShowMyWeather();
		void ShowWeatherFor();
};

#endif // WEATHER_H
