#ifndef KADU_CHAT_WINDOW_H
#define KADU_CHAT_WINDOW_H

#include "chat_widget.h"
#include "configuration_aware_object.h"

class QTimer;

class ChatWindow : public QWidget, public ChatContainer, ConfigurationAwareObject
{
	Q_OBJECT

private:
	ChatWidget *currentChatWidget;
	QTimer *title_timer;  /*!< zmienna przechowujca czas od ostatniego odwieenia tytuu okna */

	void kaduStoreGeometry();
	void kaduRestoreGeometry();

	bool activateWithNewMessages; /*!< czy aktywujemy okno po przyjciu nowej wiadomoci */
	bool showNewMessagesNum; /*!< czy pokazujemy liczb nowych wiadomoci w tytule nieaktywnego okna */
	bool blinkChatTitle; /*!< czy tytu nieaktywnego okna z nieprzeczytanymi wiadomociami powinien mruga */

private slots:
	void updateTitle();

protected:
	/**
		\fn virtual void closeEvent(QCloseEvent* e)
		Funkcja obsugujca zamknicie okna
	**/
	virtual void closeEvent(QCloseEvent *e);

	/**
		\fn virtual void windowActivationChange(bool oldActive)
		Funkcja sterujca mruganiem napisu okna
	**/
	virtual void windowActivationChange(bool oldActive);

	virtual void configurationUpdated();

public:
	ChatWindow(QWidget *parent = 0);
	virtual ~ChatWindow();

	void setChatWidget(ChatWidget *chatWidget);
	ChatWidget * chatWidget();

	void closeChatWidget(ChatWidget *chatWidget);

public slots:
	// TODO: rename
	void blinkTitle();
	void showNewMessagesNumInTitle();

	/**
		\fn void alertNewMessage()
		Slot informujcy o nowej wiadomoci
		mruganie jeli okno jest nieaktywne
	**/
	void alertNewMessage();

signals:
	void chatWidgetActivated(ChatWidget *);

};

#endif
