import os
from datetime import date, datetime
from HTMLTags import *
import md5

import k_config

from buzhug import Base

def makeDict(res):
    # convert the result of a select into a list of dictionaries
    records = []
    for item in res:
        records.append(dict([(fname,getattr(item,fname))
            for fname in ['__id__']+field_names ]))
    return records

__id__ = '__id__'

Types = {
    int : int,
    str : str,
    float : float,
    datetime : datetime,
    date : date
    }



#parameters
from genScript import Field
from datetime import date,datetime

name = 'app_buzhug'
fields = [Field('name',str,'input')]
dbmodule = 'buzhug'
security = 'standard'
base_name = 'test'
host = 'localhost'
user = 'root'
passwd = 'passwd'


field_names = [ f.name for f in fields ]
field_types = [ Types[f.Type] for f in fields ]

# open base
db = Base(base_name)
field_defs = zip(field_names, field_types)
mode = {'mode':'open'}
db.create(*field_defs,**mode)
# set default format for dates and datetimes
if date in field_types:
    db.set_string_format(date,'%Y-%m-%d')
if datetime in field_types:
    db.set_string_format(datetime,'%Y-%m-%s %H:%M:%S')



#header
header=HEAD(LINK(rel="stylesheet",href="../../default.css") +
    TITLE(name))

user_test = hasattr(Session(),'app_buzhug_user')

def index():
    print '<html>\n'
    print header
    print H1(name)
    # select all the items and return a list of dictionaries, one
    # for each record, indexed by the field names
    records = makeDict(db.select())


    if records:
        print '<table class="main" cellpadding="3" cellspacing="0">'
        print '<tr>'
        print Sum([TH(f,Class="main") for f in field_names])
        if user_test:
            print TH('&nbsp;',Class="main")*2
        print '</tr>\n'
        counter = 0
        for record in records:
            counter+=1
            if counter % 2:
                print '<tr class="even">'
            else:
                print '<tr class="odd">'
            for f in field_names:
                print TD(record[f],Class="main")
            if user_test:
                print TD(A('Remove',
                    href="removeRecord?record_id=%s" %record[__id__]),
                    Class="main")
                print TD(A('Edit',
                    href="editRecord?record_id=%s" %record[__id__]),
                    Class="main")
            print '</tr>'
        print '</table>'
    else:
        print "Empty base"

    if user_test:
        print '<p><a href="editRecord?record_id=-1">New record</a>'
        print '<p><a href="logout">Logout</a>'
    else:
        print '<p><a href="login">Login</p>'

    print '</body>\n</html>'

def editRecord(record_id):
    record_id=int(record_id)
    print header
    print '<body>'
    print SCRIPT(Type='text/JavaScript',src='../scw.js')
    print '<script>scwDateOutputFormat  = "YYYY-MM-DD"'
    print 'scwDateInputSequence = "YMD"'
    print '</script>'

    if record_id>-1:
        
        record = makeDict([db[record_id]])[0]

        print H1("Editing a record")
    else:
        print H1("New record")
        record=dict([(f,'') for f in field_names])
    
    print '<form action="insertRecord" method="post">'

    print INPUT(type="hidden",name="record_id",value=record_id)
    print '<table>'
    for field in fields:
        fn = field.name
        if field.input_format == 'textarea':
            print TR(TD(fn)+
                  TD(TEXTAREA(record[fn],name="fn",rows="10",cols="50")))          
        elif field.input_format == 'calendar':
            print TR(TD(fn)+
                  TD(INPUT(name=fn,id=fn,size="20",value=record[fn])+
                    A(IMG(src="../Calandar.gif",border=0),
                    href= "javascript:scwShow(document.getElementById('%s'), this);" %fn)))
        else:
            print TR(TD(fn)+
                     TD(INPUT(name=fn,size="40",value=record[fn])))
    print '</table>'
    print INPUT(type="submit",value="Ok")
    print '</form>'
    print '</body>\n</html>'

def insertRecord(record_id,**untyped_fields):

    record_id=int(record_id)
    
    typed_fields = db.apply_types(**untyped_fields)
    if record_id==-1:
        db.insert(**typed_fields)
    else:
        db.update(db[record_id],**typed_fields)

    raise HTTP_REDIRECTION,"index"

def removeRecord(record_id):
    
    del db[int(record_id)]

    raise HTTP_REDIRECTION,"index"

def login():
    print H1("Login")
    print '<form action="check_login" method="post">'
    print TABLE(
        TR(TD("Login")+TD(INPUT(name="login"))) +
        TR(TD("Password")+
            TD(INPUT(name="password", Type="password"))) +
        TR(TD(INPUT(Type="submit",value="Ok"))+
            TD("&nbsp;"))
        )
    print '</form>'

def check_login(**user_data):
    digest=open("app_buzhug.ini","rb").read()
    userDigest=digest[:16]
    passwordDigest=digest[16:]

    if (md5.new(user_data['login']).digest()==userDigest \
            and md5.new(user_data['password']).digest()==passwordDigest):
        setattr(Session(),'%s_user' %name, user_data['login'])
        raise HTTP_REDIRECTION,'index'
    else:    
        print "Authentication failed"
        print P(A("Back",href="index"))

def logout():
    Session().close()
    raise HTTP_REDIRECTION,'index'
    
def error(msg):
    print header
    print H1(pageTitle)
    print msg
    print P(A('Back',href='index'))
