import os
from datetime import date, datetime
from HTMLTags import *
import md5

import k_config

import MySQLdb

def makeDict(res):
    # convert the result of a cursor.fetchall() to a list
    # of dictionaries
    records = []
    for item in res:
        records.append(dict([(fname,item[i])
            for (i,fname) in enumerate(['recno']+field_names)]))
    return records

__id__ = 'recno'

Types = {
    int : 'INTEGER',
    str : 'TEXT',
    float : 'FLOAT',
    datetime : 'DATETIME',
    date : 'DATE'
    }



#parameters
from datetime import date,datetime

name = 'teams'
fields = [['birth','DATE','calendar'],
['name','VAR_STRING(200)','input']]
dbmodule = 'mysql'
security = 'low'
base_name = 'test'
host = 'localhost'
user = 'root'
passwd = 'admin'


field_names = [ f[0] for f in fields ]
field_types = [ f[1] for f in fields ]

# open connection
connection = MySQLdb.connect(host=host,user=user,passwd=passwd,db=base_name)
cursor = connection.cursor()
cursor.execute('SHOW TABLES')
existing = [ t[0] for t in cursor.fetchall() ]
if not name in existing:
    sql = 'CREATE TABLE %s (recno INTEGER PRIMARY KEY AUTO_INCREMENT,' %name
    sql += ','.join([ '%s %s'%(n,t) for (n,t) in zip(field_names,field_types)])+')'
    cursor.execute(sql)



#header
header=HEAD(LINK(rel="stylesheet",href="../../default.css") +
    TITLE(name))

def index():
    print '<html>\n'
    print header
    print H1(name)
    # select all the items and return a list of dictionaries, one
    # for each record, indexed by the field names
    cursor.execute('SELECT %s FROM %s' %(','.join(['recno']+field_names),name))
    records = makeDict(cursor.fetchall())


    if records:
        print '<table class="main" cellpadding="3" cellspacing="0">'
        print '<tr>'
        print Sum([TH(f,Class="main") for f in field_names])
        print TH('&nbsp;',Class="main")*2
        print '</tr>\n'
        counter = 0
        for record in records:
            counter+=1
            if counter % 2:
                print '<tr class="even">'
            else:
                print '<tr class="odd">'
            for f in field_names:
                print TD(record[f],Class="main")
            print TD(A('Remove',
                href="removeRecord?record_id=%s" %record[__id__]),
                Class="main")
            print TD(A('Edit',
                href="editRecord?record_id=%s" %record[__id__]),
                Class="main")
            print '</tr>'
        print '</table>'
    else:
        print "Empty base"

    print '<p><a href="editRecord?record_id=-1">New record</a>'

    print '</body>\n</html>'

def editRecord(record_id):
    record_id=int(record_id)
    print header
    print '<body>'
    print SCRIPT(Type='text/JavaScript',src='../scw.js')
    print '<script>scwDateOutputFormat  = "YYYY-MM-DD"'
    print 'scwDateInputSequence = "YMD"'
    print '</script>'

    if record_id>-1:
        field_string = ','.join(field_names)
        sql = 'SELECT recno,%s FROM %s WHERE recno = %s'             %(field_string,name,record_id)
        cursor.execute(sql)
        record = makeDict(cursor.fetchall())[0]
        connection.close()
        print H1("Editing a record")
    else:
        print H1("New record")
        record=dict([(f,'') for f in field_names])
    
    print '<form action="insertRecord" method="post">'

    print INPUT(type="hidden",name="record_id",value=record_id)
    print '<table>'
    for field in fields:
        fn = field.name
        if field.input_format == 'textarea':
            print TR(TD(fn)+
                  TD(TEXTAREA(record[fn],name="fn",rows="10",cols="50")))          
        elif field.input_format == 'calendar':
            print TR(TD(fn)+
                  TD(INPUT(name=fn,id=fn,size="20",value=record[fn])+
                    A(IMG(src="../Calandar.gif",border=0),
                    href= "javascript:scwShow(document.getElementById('%s'), this);" %fn)))
        else:
            print TR(TD(fn)+
                     TD(INPUT(name=fn,size="40",value=record[fn])))
    print '</table>'
    print INPUT(type="submit",value="Ok")
    print '</form>'
    print '</body>\n</html>'

def insertRecord(record_id,**untyped_fields):

    record_id=int(record_id)
    
    field_string = ','.join(field_names)
    # replace single quotes by double quotes
    for (k,v) in untyped_fields.items():
        untyped_fields[k]=v.replace("'","''")
    if record_id == -1:
        vals = ','.join(["'%s'" %untyped_fields[f] for f in field_names])
        sql = 'INSERT INTO %s (%s) VALUES (%s)' \
            %(name,field_string,vals)
    else:
        vals = ','.join(["%s = '%s'" %(k,v) for (k,v) in untyped_fields.iteritems()])
        sql = 'UPDATE %s SET %s WHERE recno = %s' %(name,vals,record_id)
    sql = unicode(sql,k_config.outputEncoding)
    cursor.execute(sql)
    connection.commit()
    connection.close()
    
    raise HTTP_REDIRECTION,"index"

def removeRecord(record_id):
    
    sql = 'DELETE FROM %s WHERE recno = %s' %(name,record_id)
    cursor.execute(sql)
    connection.commit()
    connection.close()

    raise HTTP_REDIRECTION,"index"

def error(msg):
    print header
    print H1(pageTitle)
    print msg
    print P(A('Back',href='index'))
