"""A script to generate the code to handle a database from
a configuration script

This script is a Python script which must define at least 2 variables :
- name   : the name of the database
- fields : a list of strings of the form "name:type" where name is the
           name of the field and type, its type
           Example : fields = ['name:str','author:str','issued:datetime.date']

Additional variables can be defined :
- dbmodule       : a string with the database module name. Defaults to 
                   'gadfly'. Must be one of 'gadfly','kirbybase','sqlite'
- security       : the security level. 3 possible values :
                   'low' : anyone can edit and remove records
                   'standard' : only logged in users can manage the base, only
                   the administrator can manage the users' base
                   'high' : only the administrator can manage the base
                   Default is 'low'
"""

import os
import cStringIO
from datetime import date,datetime
import sys
import md5

import locale
locale.setlocale(locale.LC_ALL,'')

class BaseDescription:

    def __init__(self,args={}):
        # defaults
        self.base_name = "test"
        self.host = "localhost"
        self.user = "root"
        self.passwd = ""
        self.table_name = ""
        self.security = 'standard'
        self.login = ''
        self.password = ''
        for k in args:
            setattr(self,k,args[k])

formats = {str:('input','textarea'),
    date:('input','calendar'),
    datetime:('input','calendar')}
formats['STRING'] = formats[str]
formats['BLOB'] = formats[str]
formats['VAR_STRING'] = formats[str]
formats['TINY_BLOB'] = formats[str]
formats['MEDIUM_BLOB'] = formats[str]
formats['LONG_BLOB'] = formats[str]
formats['DATETIME'] = formats[datetime]
formats['DATE'] = formats[date]

def save_admin_info(admin_file,login,password):
    # save md5 digest of the login and password
    out = open(admin_file,'wb')
    out.write(md5.new(login).digest())
    out.write(md5.new(password).digest())
    out.close()

def get_security(configFile):
    # initialize the variables
    conf_vars = {}
    execfile(configFile,conf_vars)
    return conf_vars.get('security','low')

def get_vars(configFile):
    # initialize the variables
    conf_vars = {'filename':configFile}
    execfile(configFile,conf_vars)
    return BaseDescription(conf_vars)

def get_base_info(base):
    dbmodule = base.dbmodule
    if dbmodule == 'mysql':
        import MySQLdb
        connection = MySQLdb.connect(host=base.host,
            user=base.user,passwd=base.passwd,db=base.base_name)
        cursor = connection.cursor()
        cursor.execute('SHOW TABLES')
        return [ table_info[0] for table_info in cursor.fetchall() ]
    elif dbmodule == 'sqlite':
        from pysqlite2 import dbapi2 as sqlite
        connection = sqlite.connect(base.base_name)
        cursor = connection.cursor()
        cursor.execute('SELECT name FROM sqlite_master WHERE type = "table"')
        return [ table_info[0] for table_info in cursor.fetchall() ]

def get_table_info(base):
    """Get table information from the arguments in base
    """
    dbmodule = base.dbmodule
    if dbmodule == 'mysql':
        import MySQLdb
        connection = MySQLdb.connect(host=base.host,
            user=base.user,passwd=base.passwd,db=base.base_name)
        cursor = connection.cursor()
        cursor.execute('DESCRIBE '+base.table_name)
        __id__ = None
        info = []
        for field in cursor.fetchall():
            Field,Type,Null,Key,Default,Extra = field
            if Key == 'PRI' and Extra == 'auto_increment':
                __id__ = Field
            else:
                info.append((Field,Type,Null,Key,Default,Extra))
        if __id__ is None:
            info = "Error - base %s has no integer primary key with auto_increment"\
                %base.table_name
        return __id__,info
    elif dbmodule == 'sqlite':
        from pysqlite2 import dbapi2 as sqlite
        connection = sqlite.connect(base.base_name)
        cursor = connection.cursor()
        cursor.execute('SELECT * FROM %s' %base.table_name)
        return [ table_info[0] for table_info in cursor.description() ]

def generate_script(base,login=None,password=None):
    # initialize the variables
    name = base.table_name
    configFile = os.path.join('config',name + '.py')
    conf = get_vars(configFile)
    
    # check if 'fields' is defined in the config file

    if not hasattr(conf,'fields'):
        print "Error - configuration script must specify a variable 'fields'"
    else:
        fields = conf.fields

    # default for database module if undefined
    if not hasattr(conf,'dbmodule'):
        try:
            import buzhug
            dbmod_name = 'buzhug'
        except:
            print "Error - no database module specified in configuration " \
                "script and buzhug not installed"
    else:
        dbmod_name = conf.dbmodule

    global types
    exec('from db_%s import *' %dbmod_name)

    field_names = [ field[0] for field in conf.fields ]
    conf.field_names = field_names

    template = open('rs_%s.tpl' %conf.security).read()
    params = open(conf.filename).read()
    exec(params)

    # open the generated ks script
    out = open(os.path.join('applications','%s.ks' %conf.name),'w')
    out.write('"""Database management\nGenerated %s"""\n\n'
        %(datetime.now().strftime('%x %X')))

    out.write(template %locals())
    out.close()
    return name