#ifndef __CATEGORY_H
#define __CATEGORY_H

#define KASCADE_BROWSER
//#define KASCADE_EDITOR

#include <string>
#include <vector>
using namespace std;

#define TRUE 1
#define FALSE 0 

class Category
{
  public:
    vector<Category *> *subCatv;
    Category *parent;	

    vector<string> *linkv, *propv;
								
    string target;
    vector<string> *data1v, *data2v;

    string name;                                    	
    string title, info, news, warning;				
    string owner, home, email;  				

    vector<string> *basev, *chatv, *discussv, *faqv, *mlistv;
        
    char invisible, realsubcat, transsummation, forcevisible;
    char selection, summation, mask, generalization;

#ifdef KASCADE_BROWSER
    char visited, visitationfailed, expanded, aliasedsubcats;
#endif	

    Category();
    ~Category();
    void addSubcat( Category *c );				
    Category *addNewCat( string );
//    void addInfo( string s );			
    void addLink( string s );    				
    void addChat( string s );
 //   void addWarning( string s );
    void addBase( string s );
    void addMlist( string s );
  //  void addNews( string s );
    void addDiscuss( string s );
    void addFaq( string s);
    void addProperty( string p1, string p2 );
    int subCatExists( string s );
    void addParagraph( string &, string );

#ifdef KASCADE_EDITOR
    void operator=(const Category&);
#endif

#ifdef KASCADE_BROWSER
    int empty();
    void printCategory();
    int isVisible();
    void inheritProperties();
    string calcTitle();
    string calcHome();
    string calcOwner();
    string calcEmail();
    Category *calcChat();
    void setNavigationFlags( char &, char &, char & );
    int unaryProperty( string property );			
    int binaryProperty( string property );
    vector<string> getPropertyValues( string property );
    int hasPropertyWithValue( string property, string op, string value );
#endif

private:
    void initialize();					
    void deleteVecs();

#ifdef KASCADE_BROWSER	
    int containsRealSubcats();
    void printOption( string &, int depth, const string & );
#endif	
};

#endif  // __CATEGORY_H

