#include "category.h"
#include "keyboard.h"
#include "globals.h"
#include "browser.h"
#include "preferences.h"
#include "categorylabel.h"
#include "globals.h"
#include "navigation.h"
#include "errors.h"

#include <qevent.h>
#include <qapplication.h>

void Keyboard::highlightUp()
{
	if( highlight-- == -1 )
		highlight = browser->allLabelv.size()/2-1;

	browser->setCatLabelColors();
	browser->checkScrollHeight();
}

void Keyboard::highlightDown()
{ 
	if( ++highlight == browser->allLabelv.size()/2 )
		highlight = -1;

	browser->setCatLabelColors();
	browser->checkScrollHeight();
}

void Keyboard::highlightFirst()
{
	highlight = 0;
	
	browser->setCatLabelColors();
	browser->checkScrollHeight();
}

void Keyboard::highlightLast()
{
	highlight = browser->allLabelv.size()/2-1;

	browser->setCatLabelColors();
	browser->checkScrollHeight();
}

void Keyboard::highlightPgUp()
{
	if( highlight == -1 )
		return; 

	int target = browser->allLabelv[2*highlight]->y() - browser->scrollView->viewport()->height();

	for( unsigned int n = 0; n < browser->allLabelv.size()/2; n++ )
	{
		int labeltop = browser->allLabelv[2*n]->y();

		if( labeltop-4 >= target )
		{
			highlight = n;
			browser->scrollView->setContentsPos( 0, labeltop-4 );
			break;
		}	
	}

	browser->setCatLabelColors();
}

void Keyboard::highlightPgDn()
{
	if( highlight == -1 )
		return; 

	int viewbottom = browser->scrollView->contentsY() + browser->scrollView->viewport()->height();

	for( unsigned int n = highlight; n < browser->allLabelv.size()/2; n++ )
	{
		int labeltop = browser->allLabelv[2*n]->y();
		int labelbottom = labeltop + browser->allLabelv[2*n]->height();

		if( labelbottom+4 > viewbottom )
		{
			highlight = n;		
			browser->scrollView->setContentsPos( 0, labeltop-4 );
			break;
		}
	}
	
	browser->setCatLabelColors();
}

void Keyboard::handleKeyPress( QKeyEvent *event )
{
	vector<int> &keybindingv = config->keyBindingv();

	for( unsigned int n = 0; n < keybindingv.size(); n += 2 )
		if( event->key() == keybindingv[n+1] )
		{
			act_on_key( keybindingv[n] );
			return;	
		}	

	act_on_key( event->key() );
}

void Keyboard::launchExt()
{
	if( highlight == -1 )
		return;

	CategoryLabel *label = (CategoryLabel *)(browser->allLabelv[2*highlight]);
	if( label->extension )
	{
		browser->extcat = label->category;
		browser->extensionOpenWith();
	}	
}

void Keyboard::act_on_key( int key )
{
	browser->keyboardaction = TRUE;

	switch( key )
	{
		case Key_O: 	update0( browser->action_openfile() );
				break;
		case Key_D:	browser->discussPressed();
				update2();
				break;
		case Key_Q:	browser->faqPressed();
				update2();
				break;
		case Key_B:	browser->basePressed();
				update2();
				break;
		case Key_E:	browser->clearCachePressed();
				update0( TRUE );
				break;
		case Key_Z: 	browser->debugWindowPressed();
				update2();
				break;
		case Key_A: 	browser->addBookmark();
				update2();
				break;
		case Key_V:	browser->showBookmarks();
				update2();
				break;
		case Key_Y:	browser->mlistPressed();
				update2();
				break;
		case Key_U:	update0( browser->action_openurl() );
				break;
		case Key_P: 	browser->showPreferences();
				update2();
				break;
		case Key_I:	browser->infoPressed();
				update2();
				break;
		case Key_N:	browser->newsPressed();
				update2();
				break;
		case Key_R: 	update0( action_jump( config->startAddress() ) );
				break;
		case Key_C: 	browser->chatPressed();
				update2();
				break;
		case Key_S:	browser->viewPageSource();
				update2();
				break;
		case Key_G:	browser->action_showlinks();
				update2();
				break;
		case Key_Left: 	update1( browser->action_backtrace() );
				break;
		case Key_F:	update1( browser->action_forwardtrace() );
				break;
		case Key_W:	launchExt();
				update2();
				break;
		case Key_Right:	if( highlight != -1 ) 
  					update0( action_enter( ((CategoryLabel *)(browser->allLabelv[2*highlight]))->category ) );
				break;
		case Key_Down: 	highlightDown();
				break;
		case Key_Up:	highlightUp();
				break;
		case Key_End:	highlightLast();
				break;
		case Key_Home:  highlightFirst();
				break;
		case Key_PageDown:
				highlightPgDn();
				break;
		case Key_X:	qApp->quit();
				break;
		case Key_PageUp:
				highlightPgUp();
				break;
		case Key_M:	browser->markPressed();
				update2();
				break;
		case Key_T:	browser->tomarkPressed();
				update2();
				break;
	}			
	
	browser->keyboardaction = FALSE;
} 
				
void Keyboard::update( int okay )
{
	if( !okay )
		return;

	browser->showNewCategory();
	browser->checkScrollHeight();
}

void Keyboard::update0( int okay )
{
	if( !okay ) 
		return;

	if( highlight != -1 )
		highlight = 0;
	browser->showNewCategory();
	browser->checkScrollHeight();
}

void Keyboard::update1( int okay )
{
	if( !okay )
		return;

	if( highlight == -1 )
		highlight = 0;
	browser->showNewCategory();
	browser->checkScrollHeight();
}

void Keyboard::update2()
{
/*	if( highlight == -1 )
	{
		highlight = 0;	
		browser->setCatLabelColors();
	}	 */
}

Keyboard::Keyboard() : QWidget()
{
}
