#include "keybox.h"

KeyBox::KeyBox( QWidget *parent ) : QDialog( parent, 0, TRUE )
{
	resize( 250, 95 );

	label = new QLabel( "Enter the new key for this action", this );
	label->setAlignment( QLabel::AlignCenter );

	cancel = new QPushButton( "Cancel", this );
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}

void KeyBox::resizeEvent( QResizeEvent * )
{
	int width = this->width();
	int height = this->height();

	label->setGeometry( 10, 10, width-20, 30 );
	cancel->setGeometry( width/2-45, height-40, 90, 30 );
}	

void KeyBox::keyPressEvent( QKeyEvent *event )
{
	key = event->key();
	accept();
}

