#include "ownerbutton.h"
#include "navigation.h"
#include "categorylabel.h"
#include "category.h"

OwnerButton::OwnerButton( QWidget *parent ) : QFrame( parent )
{
	setFrameStyle( QFrame::Panel | QFrame::Raised );
	setLineWidth( 2 );
	setCursor( pointingHandCursor );

	label = new CategoryLabel( this, (Category *)1 );
	label->setAlignment( QLabel::AlignCenter );
	QObject::connect( label, SIGNAL( LeftMouseButtonClicked( Category * ) ), this, SLOT( tinkywinky( Category * ) ) ); 
}

void OwnerButton::tinkywinky( Category * )
{
	emit clicked();
}

void OwnerButton::resizeEvent( QResizeEvent * )
{
	label->setGeometry( 3, 2, this->width()-6, this->height()-4 );
}

void OwnerButton::setText( string text )
{
	label->setText( text.c_str() );
}

