#include <sys/types.h>
#include <sys/stat.h>

#include <qmessagebox.h>
#include <qspinbox.h>

#include "preferences.h"
#include "network.h"
#include "appearance.h"
#include "fontscolors.h"
#include "advanced.h"
#include "utility.h"
#include "globals.h"
#include "browser.h"

Preferences::Preferences() : QTabDialog()
{
        addTab( netw = new network(), "General" );
        addTab( appe = new appearance(), "Interface" );
        addTab( fcol = new fontscolors(), "Appearance" );
        addTab( adva = new advanced(), "Advanced" );

        resize( 550, 440 );
        setCaption( "Kascade Preferences" );
	setCancelButton();
	setOKButton( "Save" );

	maincoords = 0;

	load();

	QObject::connect( this, SIGNAL( applyButtonPressed() ), this, SLOT( save() ) );
}

void Preferences::checkConfig()
{
	string conf;
	conf = getenv( "HOME" );
	conf += "/.kascade";

	ifstream ifs;
	ifs.open( conf.c_str() );
	if( !ifs.good() )
	{
		mkdir( conf.c_str(), S_IRUSR | S_IWUSR | S_IXUSR | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH );

		ifstream ifs;
		ofstream ofs;

		ifs.open( "/usr/share/kascade/config" );
		ofs.open( ( conf + "/config" ).c_str() );
	
		string line;
		while( !ifs.eof() )
		{
			getline( ifs, line, '\n' );
			ofs << line << endl;
		}
	}
}

void Preferences::loadLocals()
{
	ifstream ifs;
	string file = getenv( "HOME" );
	file += "/.kascade/locals";

	ifs.open( file.c_str() );

	if( !ifs.good() )
		return;

    	ifs.unsetf( ios::skipws );

	string address, local;

	while( !ifs.eof() )
	{
        	getline( ifs, address, '\n' );
        	getline( ifs, local, '\n' );

		if( address != "" )
		{
			config->bookmarkv.push_back( address );
			config->bookmarkv.push_back( local );
		}	
	}

	ifs.close();
}

void Preferences::load()
{
	checkConfig();
	
	ifstream ifs;
	string file = getenv( "HOME" );
	file += "/.kascade/config";
	ifs.open( file.c_str() );

	if( !ifs.good() )
	{
		QMessageBox::warning( this, "Warning!", "Could not open config file" );
		return;
	}

	while( !ifs.eof() )
	{
		string var;
		ifs >> var;

		if( var == "highlightforeground" )
			loadColor( ifs, fcol->highlightForeground );
		else if( var == "highlightbackground" )
			loadColor( ifs, fcol->highlightBackground );
		else if( var == "titleforeground" )
			loadColor( ifs, fcol->titleForeground );
		else if( var == "titlebackground" )
			loadColor( ifs, fcol->titleBackground );
		else if( var == "visitedforeground" )
			loadColor( ifs, fcol->visitedColor );
		else if( var == "extensionforeground" )
			loadColor( ifs, fcol->extensionColor );
		else if( var == "backgroundcolor" )
			loadColor( ifs, fcol->backgroundColor );

		else if( var == "maincoords" )
			loadCoords( ifs, maincoords );

		else if( var == "keybinding" )
		{
			int option, key;
			ifs >> option >> key;

			for( unsigned int n = 0; n < adva->keyBindingv.size(); n += 2 )
				if( (adva->keyBindingv)[n] == option )
				{
					(adva->keyBindingv)[n+1] = key;
					break;
				}	
		}

		else
		{
			string line;
			getline( ifs, line, '\n' );
			
			if( ( line != "" ) &&
			    ( line[0] == ' ' ) )
				line.erase( 0, 1 );
			
			if( var == "startaddress" )
				loadLineEdit( line, netw->LEstartaddress );
			else if( var == "cacheserver" )
				loadLineEdit( line, netw->LEcacheserver );
			else if( var == "emailaddress" )
				loadLineEdit( line, netw->LEemailaddress );
			else if( var == "smtpserver" )
				loadLineEdit( line, netw->LEsmtpserver );
				else if( var == "ircserver" )
				loadLineEdit( line, netw->LEircserver );
			else if( var == "nickname1" )
				loadLineEdit( line, netw->LEnickname1 );
			else if( var == "nickname2" )
				loadLineEdit( line, netw->LEnickname2 );
			else if( var == "nickname3" )
				loadLineEdit( line, netw->LEnickname3 );
			else if( var == "nickname4" )
				loadLineEdit( line, netw->LEnickname4 );
			else if( var == "sourcefont" )
				loadLineEdit( line, fcol->LEsourcefont );
			else if( var == "browserfont" )
				loadLineEdit( line, fcol->LEbrowserfont );
			else if( var == "emailfont" )
				loadLineEdit( line, fcol->LEemailfont );
			else if( var == "ircfont" )
				loadLineEdit( line, fcol->LEircfont );
			else if( var == "iconsetdir" )
				loadLineEdit( line, appe->LEiconsetdir );
			else if( var == "sourceviewer" )
				loadLineEdit( line, appe->LEexternalsourceviewer );
			else if( var == "emailclient" )
				loadLineEdit( line, adva->LEemailclient );
			else if( var == "ircclient" )
				loadLineEdit( line, adva->LEircclient );
			else if( var == "newsclient" )
				loadLineEdit( line, adva->LEnewsclient );
			else if( var == "webbrowser" )
				loadLineEdit( line, adva->LEwebbrowser );

			else if( var == "externalsourceviewer" )
				loadCheck( line, appe->CBexternalsourceviewer );
			else if( var == "uppertoolbar" )
				loadCheck( line, appe->CBuppertoolbar );
			else if( var == "statusbar" )
				loadCheck( line, appe->CBstatusbar );
			else if( var == "enableediting" )
				loadCheck( line, appe->CBenableediting );
			else if( var == "externalirc" )
				loadCheck( line, adva->CBexternalirc );
			else if( var == "externalemail" )
				loadCheck( line, adva->CBexternalemail );

			else if( var == "timeoutvalue" )
				adva->SBtimeout->setValue( stringtoi( line ) );

			else if( var == "toolbardock" )
{
  int dck = stringtoi( line );
  switch (dck)
  {
    case 0: dock = QMainWindow::Unmanaged; break;
    case 1: dock = QMainWindow::TornOff; break;
    case 2: dock = QMainWindow::Top; break;
    case 3: dock = QMainWindow::Bottom; break;
    case 4: dock = QMainWindow::Right; break;
    case 5: dock = QMainWindow::Left; break;
    case 6: dock = QMainWindow::Minimized; break;
  }
}
//				dock = (QMainWindow::ToolBarDock)stringtoi( line );

			loadButton( var );
		}
	}
	
	ifs.close();

	fcol->LEsourcefont->setCursorPosition( 0 );
	fcol->LEemailfont->setCursorPosition( 0 );
	fcol->LEbrowserfont->setCursorPosition( 0 );
	fcol->LEircfont->setCursorPosition( 0 );
	
	adva->fillListBox();
	appe->connect();
}

void Preferences::loadButton( string var )
{
	if( var == "backbutton" )
		appe->LBselected->insertItem( "back" );
	else if( var == "infobutton" )
		appe->LBselected->insertItem( "information" );
	else if( var == "chatbutton" )
		appe->LBselected->insertItem( "chat" );
	else if( var == "linksbutton" )
		appe->LBselected->insertItem( "links" );
	else if( var == "rootbutton" )
		appe->LBselected->insertItem( "new search" );
	else if( var == "stopbutton" )
		appe->LBselected->insertItem( "stop" );
	else if( var == "newsbutton" )
		appe->LBselected->insertItem( "news" );
	else if( var == "discussbutton" )
		appe->LBselected->insertItem( "discuss" );
	else if( var == "forwardbutton" )
		appe->LBselected->insertItem( "forward" );
	else if( var == "bookmarksbutton" )
		appe->LBselected->insertItem( "bookmarks" );
	else if( var == "markbutton" )
		appe->LBselected->insertItem( "mark" );
	else if( var == "tomarkbutton" )
		appe->LBselected->insertItem( "to mark" );
	else if( var == "basebutton" )
		appe->LBselected->insertItem( "bases" );
}

void Preferences::saveButton( ofstream &ofs, QToolButton *button, string name )
{
	if( button->isVisible() )
		ofs << name << endl;
}
		
void Preferences::saveCoords( ofstream &ofs, QWidget *w )
{
	ofs << "maincoords " << w->x() << " " << w->y() << " " << w->width() << " " << w->height() << endl;
}

void Preferences::loadCheck( string onoff, QCheckBox *cb )
{
	cb->setChecked( onoff == "on" );
}

void Preferences::saveCheck( ofstream &ofs, string name, QCheckBox *cb )
{
	ofs << name << ( cb->isChecked() ? " on" : " off" ) << endl;
}

void Preferences::loadColor( ifstream &ifs, QColor &color )
{
	int red, green, blue;
	ifs >> red >> green >> blue;

	color.setRgb( red, green, blue );
}

void Preferences::loadCoords( ifstream &ifs, QRect *&rect )
{
	int x, y, w, h;
	ifs >> x >> y >> w >> h;
	rect = new QRect( x, y, w, h );
}

void Preferences::saveColor( ofstream &ofs, QColor &color, string name )
{
	ofs << name << " " << color.red() << " " << color.green() << " " << color.blue() << endl;
}

void Preferences::loadLineEdit( string text, QLineEdit *lineedit )
{
	lineedit->setText( text.c_str() ); 
}

void Preferences::saveLineEdit( ofstream &ofs, QLineEdit *lineedit, string name )
{
	string text = (const char *)(lineedit->text());

	ofs << name << " " << text << endl;
}

void Preferences::save()
{
	ofstream ofs;
	string file = getenv( "HOME" );
	file += "/.kascade/config";
	ofs.open( file.c_str() );
	
	saveLineEdit( ofs, netw->LEstartaddress, "startaddress" );
	saveLineEdit( ofs, netw->LEcacheserver, "cacheserver" );
	saveLineEdit( ofs, netw->LEemailaddress, "emailaddress" );
	saveLineEdit( ofs, netw->LEsmtpserver, "smtpserver" );
	saveLineEdit( ofs, netw->LEircserver, "ircserver" );
	saveLineEdit( ofs, netw->LEnickname1, "nickname1" );
	saveLineEdit( ofs, netw->LEnickname2, "nickname2" );
	saveLineEdit( ofs, netw->LEnickname3, "nickname3" );
	saveLineEdit( ofs, netw->LEnickname4, "nickname4" );
	saveLineEdit( ofs, fcol->LEsourcefont, "sourcefont" );
	saveLineEdit( ofs, fcol->LEbrowserfont, "browserfont" );
	saveLineEdit( ofs, fcol->LEemailfont, "emailfont" );
	saveLineEdit( ofs, fcol->LEircfont, "ircfont" );
	saveLineEdit( ofs, appe->LEiconsetdir, "iconsetdir" );
	saveLineEdit( ofs, appe->LEexternalsourceviewer, "sourceviewer" );
	saveLineEdit( ofs, adva->LEemailclient, "emailclient" );
	saveLineEdit( ofs, adva->LEircclient, "ircclient" );
	saveLineEdit( ofs, adva->LEnewsclient, "newsclient" );
	saveLineEdit( ofs, adva->LEwebbrowser, "webbrowser" );

	saveColor( ofs, fcol->titleForeground, "titleforeground" );
	saveColor( ofs, fcol->titleBackground, "titlebackground" );
	saveColor( ofs, fcol->highlightForeground, "highlightforeground" );
	saveColor( ofs, fcol->highlightBackground, "highlightbackground" );
	saveColor( ofs, fcol->visitedColor, "visitedforeground" );
	saveColor( ofs, fcol->extensionColor, "extensionforeground" );
	saveColor( ofs, fcol->backgroundColor, "backgroundcolor" );

	saveCheck( ofs, "externalsourceviewer", appe->CBexternalsourceviewer );
	saveCheck( ofs, "uppertoolbar", appe->CBuppertoolbar );
	saveCheck( ofs, "statusbar", appe->CBstatusbar );
	saveCheck( ofs, "enableediting", appe->CBenableediting );
	saveCheck( ofs, "externalirc", adva->CBexternalirc );
	saveCheck( ofs, "externalemail", adva->CBexternalemail );

	saveButton( ofs, browser->TBback, "backbutton" );
	saveButton( ofs, browser->TBinfo, "infobutton" );
	saveButton( ofs, browser->TBchat, "chatbutton" );
	saveButton( ofs, browser->TBlinks, "linksbutton" );
	saveButton( ofs, browser->TBroot, "rootbutton" );
	saveButton( ofs, browser->TBmark, "markbutton" );
	saveButton( ofs, browser->TBtomark, "tomarkbutton" );
	saveButton( ofs, browser->TBstop, "stopbutton" );

	ofs << "timeoutvalue " << adva->SBtimeout->value() << endl;

	string beh = "ageraluon";
	saveCoords( ofs, browser );

	int x;
	bool bx;
	if (x) bx = TRUE; else bx = FALSE;
	browser->getLocation( browser->toolBar, dock, x, bx, x );
	
	ofs << "toolbardock " << (int)dock << endl;

	for( unsigned int n = 0; n < adva->keyBindingv.size(); n += 2 )
		ofs << "keybinding " << adva->keyBindingv[n] << " " << adva->keyBindingv[n+1] << endl; 

	ofs.close();
}

string Preferences::startAddress()
{
	return (const char *)(netw->LEstartaddress->text()); 
}

string Preferences::cacheServer()
{
	string server = (const char *)(netw->LEcacheserver->text()); 
	if( ( server != "" ) && 
	    ( server.find( "http://" ) != 0 ) )
		server = "http://" + server;

	return server;	
}

string Preferences::emailAddress()
{
	return (const char *)(netw->LEemailaddress->text()); 
}

string Preferences::smtpServer()
{
	return (const char *)(netw->LEsmtpserver->text()); 
}

string Preferences::ircServer()
{
	return (const char *)(netw->LEircserver->text()); 
}

void Preferences::toolbarIcons( vector< string > &icons )
{
	for( unsigned int n = 0; n < appe->LBselected->count(); n++ )
		icons.push_back( (const char *)(appe->LBselected->text( n ) ) );	
}

string Preferences::ircNickname( int i )
{
	switch( i )
	{
		case 1: 	return (const char *)(netw->LEnickname1->text()); 
		case 2: 	return (const char *)(netw->LEnickname2->text()); 
		case 3: 	return (const char *)(netw->LEnickname3->text()); 
		case 4: 	return (const char *)(netw->LEnickname4->text()); 
	}

	return "";
}

string Preferences::iconDir()
{
	return (const char *)(appe->LEiconsetdir->text());
}

QColor Preferences::extensionColor()
{
	return fcol->extensionColor;
}

QColor Preferences::backgroundColor()
{
	return fcol->backgroundColor;
}

QColor Preferences::visitedColor()
{
	return fcol->visitedColor;
}

QColor Preferences::titleForeground()
{
	return fcol->titleForeground;
}

QColor Preferences::titleBackground()
{
	return fcol->titleBackground;
}	

QColor Preferences::highlightForeground()
{
	return fcol->highlightForeground;
}

QColor Preferences::highlightBackground()
{
	return fcol->highlightBackground;
}

vector<int> &Preferences::keyBindingv()
{
	return adva->keyBindingv;
}	

QFont Preferences::sourceFont()
{
	QFont f;
	f.setRawName( fcol->LEsourcefont->text() );
	return f;
}

QFont Preferences::browserFont()
{
	QFont f;
	f.setRawName( fcol->LEbrowserfont->text() );
	return f;
}

QFont Preferences::emailFont()
{
	QFont f;
	f.setRawName( fcol->LEemailfont->text() );
	return f;
}

QFont Preferences::ircFont()
{
	QFont f;
	f.setRawName( fcol->LEircfont->text() );
	return f;
}

string Preferences::sourceViewer()
{
	if( !appe->CBexternalsourceviewer->isChecked() )
		return "";
	return (const char *)(appe->LEexternalsourceviewer->text());
}

int Preferences::upperToolbar()
{
	return appe->CBuppertoolbar->isChecked();
}

int Preferences::statusBar()
{
	return appe->CBstatusbar->isChecked();
}

int Preferences::editingOptions()
{
	return appe->CBenableediting->isChecked();
}

string Preferences::webBrowser()
{
	return (const char *)(adva->LEwebbrowser->text());	
}

void Preferences::setWebBrowser( string browser )
{
	adva->LEwebbrowser->setText( browser.c_str() );
}

string Preferences::emailClient()
{
	if( !adva->CBexternalemail->isChecked() )
		return "";
	return (const char *)(adva->LEemailclient->text());
}

string Preferences::newsClient()
{
	return (const char *)(adva->LEnewsclient->text());
}

string Preferences::ircClient()
{
	if( !adva->CBexternalirc->isChecked() )
		return "";
	return (const char *)(adva->LEircclient->text());
}	

int Preferences::timeoutValue()
{
	return 1000 * adva->SBtimeout->value();
}
