module Portability5 where

import Lib
import System.IO
import System.Posix

-- GHC 5.04 and above library incompatibilities.

environment :: String -> IO (Maybe String)
environment x = getEnv x

tempfile :: IO (FilePath, Handle)
tempfile = do env <- environment "TMPDIR"
	      let dir = case env of
		   Nothing -> tmpdir
		   (Just d) -> d
	      mkstemp $ tmpdir ++ "/kaya_XXXXXX"
