/** -*-C-*-ish
    MySQL interface library for Kaya
    Copyright (C) 2005,2006 Chris Morris

    Based on the Postgres interface library Copyright (C) 2004, 2005
    Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence. When linked against a version
    of libmysqlclient that is GPL licensed then you must either use section 3
    of the LGPL to change the copy used for linking to GPL, or use the FLOSS
    Exception published by MySQL if that is applicable to your circumstances.
*/

#include "my_inter.h"
#include <VMState.h>
#include <KayaAPI.h>

void* do_mysql_connect(KString rawhost, KString rawuser, KString rawpass, KString rawdb, KInt rawport)
{
  char* host = CSTRING(rawhost);
  char* user = CSTRING(rawuser);
  char* pass = CSTRING(rawpass);
  char* db = CSTRING(rawdb);
  int port = CINT(rawport);

  MYSQL* mc = mysql_init(NULL);
  mc = mysql_real_connect(mc,host,user,pass,db,port,NULL,0);

  MyCon * myc = new MyCon();
  myc->con = mc;
  myc->ok = 1;
  if (mc == NULL) {
    myc->ok = 0;
  }    
  return (void*)myc;
}

bool my_ok(void* conn)
{
    MyCon* myc = (MyCon*)conn;
//    cout << pgc->ok << endl;
    return myc->ok;
}

/*wchar_t* pg_getError(void* conn)
{
    PGconn* pgc = ((PGCon*)conn)->con;
    return strtowc(PQerrorMessage(pgc));
}*/
/* we don't need this function for now, and it needs calling something else when we do bring it back
DBtype getDBtype(wchar_t* rawval)
{
  // MySQL doesn't appear to have a convenient type interface
  return DBTEXT;
} */


void* do_mysql_query(void* vmptr,void* conn,KString rawquery)
{
  char* query = CSTRING(rawquery);
  VMState* vm = (VMState*)vmptr;
  MyCon* myc = (MyCon*)conn;

  int success = mysql_query(myc->con,query);
  if (success!=0) {
    // TODO: make this more helpful
    vm->kaya_throw("MySQL Query error occurred",1);
  }
  MYSQL_RES* res = mysql_store_result(myc->con);
  MyRes* myr = new MyRes();
  if (res == NULL) {
    // INSERT, etc.
    myr -> res_table = newKayaArray(0);
    myr -> rows = 0;
    myr -> cols = 0;
    myr -> colnames = newKayaArray(0);
    myr -> myres = res;
    

  } else {
    int numrows = mysql_num_rows(res);
    int numflds = mysql_num_fields(res);
    
    KayaArray resarray = newKayaArray(numrows);

    for(int i = 0; i<numrows; i++) {
      KayaArray row = newKayaArray(numflds);
      MYSQL_ROW myrow = mysql_fetch_row(res);
      for(int j = 0; j<numflds; j++) {
	char* val = myrow[j];
	KayaValue pv,fld;
	pv = KayaString(KSTRING(val));
	fld = KayaUnion(0,1);
	KayaUnionSetArg(fld,0,pv);
	KayaArrayPush(row,fld);
      }
      KayaArrayPush(resarray,KayaArrayVal(row));
    }

    KayaArray colarray = newKayaArray(numflds);
    MYSQL_FIELD* mfields = mysql_fetch_fields(res);
    for(int k = 0; k<numflds; k++) {
      char* fn = mfields[k].name;
      KayaValue fname = KayaString(KSTRING(fn));
      KayaArrayPush(colarray,fname);
    }

    myr -> res_table = resarray;
    myr -> rows = numrows;
    myr -> cols = numflds;
    myr -> colnames = colarray;
    myr -> myres = res;

    mysql_free_result(res);
  }
  return myr;
}

void* do_mysql_incquery(void* vmptr,void* conn,KString rawquery)
{
  char* query = CSTRING(rawquery);
  VMState* vm = (VMState*)vmptr;
  MyCon* myc = (MyCon*)conn;

  int success = mysql_query(myc->con,query);
  if (success!=0) {
    // TODO: make this more helpful
    vm->kaya_throw("MySQL Query error occurred",1);
  }
  MYSQL_RES* res = mysql_store_result(myc->con);
  MyRes* myr = new MyRes();
  if (res == NULL) {
    // INSERT, etc.
    myr -> rows = 0;
    myr -> cols = 0;
    myr -> colnames = newKayaArray(0);
    myr -> myres = res;
  } else {
    int numrows = mysql_num_rows(res);
    int numflds = mysql_num_fields(res);
    
    KayaArray colarray = newKayaArray(numflds);
    MYSQL_FIELD* mfields = mysql_fetch_fields(res);
    for(int k = 0; k<numflds; k++) {
      char* fn = mfields[k].name;
      KayaValue fname = KayaString(KSTRING(fn));
      KayaArrayPush(colarray,fname);
    }

    myr -> rows = numrows;
    myr -> cols = numflds;
    myr -> colnames = colarray;
    myr -> myres = res;
  }
  return myr;
}

Array* my_getrow(void* vmptr, void* resptr) {
  VMState* vm = (VMState*)vmptr;
  MYSQL_RES* res = ((MyRes*)resptr)->myres;
  int numflds = mysql_num_fields(res);
  KayaArray row = newKayaArray(numflds);
  MYSQL_ROW myrow = mysql_fetch_row(res);
  if (myrow == NULL) {
    vm->kaya_throw("Tried to read more result rows than exist.",1);
  }
  for(int j = 0; j<numflds; j++) {
    char* val = myrow[j];
    KayaValue pv,fld;
    pv = KayaString(KSTRING(val));
    fld = KayaUnion(0,1);
    KayaUnionSetArg(fld,0,pv);
    KayaArrayPush(row,fld);
  }
  return row;
}

void my_discard(void* resptr) {
  MYSQL_RES* res = ((MyRes*)resptr)->myres;
  mysql_free_result(res);
}

Array* my_getstrs(void* res)
{
    return ((MyRes*)res)->res_table;
}

Array* my_colnames(void* res)
{
    return ((MyRes*)res)->colnames;
}

int my_numrows(void* res)
{
    return ((MyRes*)res)->rows;
}

int my_numcols(void* res)
{
    return ((MyRes*)res)->cols;
}

void do_mysql_close(void* conn)
{
    mysql_close(((MyCon*)conn)->con);
}
