#include <pthread.h>

#include "thread_glue.h"
#include <VM.h>
#include <VMState.h>

void* threadFn(void* vfn)
{
    ThreadStartup* ts = (ThreadStartup*)vfn;
    // Make new vm data, push the argument, call the function.
    VMState* vm = initstack();
//    cout << "Making new vm " << vm << endl;
    PUSH(ts->arg);
    CALLFUN(ts->fn);
    return vm->doPop();
}

void* createThread(Value* fn,Value* arg)
{
    ThreadStartup* ts = new ThreadStartup();
    ts->fn = fn;
    ts->arg = arg;

    pthread_t t;
    pthread_create(&t,NULL,threadFn,(void*)ts);
    ThreadData* td = new ThreadData();
    td->t_id = t;
    return (void*)td;
}

Value* waitForThread(void* tid)
{
    ThreadData* td = (ThreadData*)tid;
    void* status;

    pthread_join(td->t_id,&status);
    return (Value*)status;
}

void killThread(void* tid)
{
    ThreadData* td = (ThreadData*)tid;
    pthread_cancel(td->t_id);
}

void endThread()
{
    pthread_exit(0);
}

void* createMutex()
{
    pthread_mutex_t m;
    pthread_mutex_init(&m,NULL);
    ThreadMutex* tm = new ThreadMutex();
    tm->m_id = m;
    return (void*)tm;
}

void lock(void* mutex)
{
    ThreadMutex* tm = (ThreadMutex*)mutex;
    pthread_mutex_lock(&(tm->m_id));
}

void unlock(void* mutex)
{
    ThreadMutex* tm = (ThreadMutex*)mutex;
    pthread_mutex_unlock(&(tm->m_id));
}

