//**************************************************************************
//                        childframemodesettings.cpp  -  description
//                           -------------------
//  begin                : Thu Nov 2 2000
//  copyright            : (C) 2000 by Bjrn Sahlstrm
//  email                : bjorn@kbear.org
//**************************************************************************/

//**************************************************************************
//                                                                         *
//   This program is free software; you can redistribute it and/or modify  *
//   it under the terms of the GNU General Public License as published by  *
//   the Free Software Foundation; either version 2 of the License, or     *
//   (at your option) any later version.                                   *
//                                                                         *
//**************************************************************************/
#include "childframemodesettings.h"

//-----------------------------------------------
void ChildFrameModeSettings::setDefaultChildFrameMode( unsigned int mode ) {
	switch( mode ) {
		case Cascade:
			p_cascade->setChecked( true);break;
		case CascadeMaximized:
			p_cascadeMaximized->setChecked( true );break;
		case ExpandVertical:
			p_expandVertical->setChecked( true );break;
		case ExpandHorizontal:
			p_expandHorizontal->setChecked( true );break;
		case AnodinesTile:
			p_anodinesTile->setChecked( true );break;
		case PragmasTile:
			p_pragmasTile->setChecked( true );break;
		case TileVertically:
			p_tileVertically->setChecked( true );break;
		case None:
			break;
	}
}
//-----------------------------------------------
unsigned int ChildFrameModeSettings::getDefaultChildFrameMode() {
	if( p_cascade->isChecked() )
		return Cascade;
	else if( p_cascadeMaximized->isChecked() )
		return	CascadeMaximized;
	else if( p_expandVertical->isChecked() )
		return ExpandVertical;
	else if( p_expandHorizontal->isChecked() )
		return ExpandHorizontal;
	else if( p_anodinesTile->isChecked() )
		return AnodinesTile;
	else if( p_pragmasTile->isChecked() )
		return PragmasTile;
	else if( p_tileVertically->isChecked() )
		return TileVertically;
	
	return None;
}
//-----------------------------------------------
