/******************************************************************************
 *   Copyright (C) 2005 Siraj Razick <siraj@kdemail.net>                      *
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This package is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the             *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this package; if not, write to the Free Software              *
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA *
 ******************************************************************************/

#ifndef KBFXCONFIG_H
#define KBFXCONFIG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include <qfont.h>
#include <qcolor.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kglobal.h>
#include <kuser.h>
#include <kiconloader.h>
#include <kconfigskeleton.h>
#include <kstandarddirs.h>

class KbfxConfig
{
public:
  void setHoverButtonPath(QString _path);
  void setNormalButtonPath(QString _path);
  void setPressedButtonPath(QString _path);

  void read();
  void readFontrc(QString &themePath, QString &themeName);
  void setDefault();
  void setFontsDefault();
  void write();
  void writeFontrc(QString &themeName);

  /* kbfx_menu_button config items list */
  QString m_KbfxGeneralVersion;
  QString m_KbfxGeneralVersionDefault;
  QString m_KbfxNormalButtonPath;
  QString m_KbfxNormalButtonPathDefault;
  QString m_KbfxHoverButtonPath;
  QString m_KbfxHoverButtonPathDefault;
  QString m_KbfxPressedButtonPath;
  QString m_KbfxPressedButtonPathDefault;
  QString m_KbfxMouseOverAnimationPath;
  QString m_KbfxMouseOverAnimationPathDefault;
  QColor m_KbfxButtonColor;
  QColor m_KbfxButtonColorDefault;
  int m_KbfxButtonSize;
  int m_KbfxButtonSizeDefault;
  bool m_KbfxButtonGlow;
  bool m_KbfxButtonGlowDefault;
  bool m_KbfxButtonKikerResize;
  bool m_KbfxButtonKikerResizeDefault;
  QString m_KbfxMenuType;
  QString m_KbfxMenuTypeDefault;

  /* spinx config items list */
  QString m_SpinxThemeBasePath;
  QString m_SpinxThemeBasePathDefault;
  QString m_UserSpinxThemeBasePath;
  QString m_UserSpinxThemeBasePathDefault;
  bool m_SpinxDudeBlink;
  bool m_SpinxDudeBlinkDefault;
  QString m_SpinxDudeImage;
  QString m_SpinxDudeImageDefault;
  QString m_SpinxThemeName;
  QString m_SpinxThemeNameDefault;
  bool m_ToolBarResize;
  bool m_ToolBarResizeDefault;
  

  /* tooltip options list */
  bool m_ToolTipAnimation;
  bool m_ToolTipAnimationDefault;
  bool m_ToolTip;
  bool m_ToolTipDefault;
  QString m_ToolTipText;
  QString m_ToolTipTextDefault;
  QString m_ToolTipAvatar;
  QString m_ToolTipAvatarDefault;

  QString m_KbfxHistory;
  QString m_KbfxHistoryDefault;
  QStringList m_KbfxHistoryCompletion;
  KConfigSkeleton *confskel;
  KConfigSkeleton *mainconfskel;

  /* font settings */
  QColor m_fontAppNameColor;
  QColor m_fontAppNameColorDefault;
  QColor m_fontAppCommentColor;
  QColor m_fontAppCommentColorDefault;
  QColor m_lineColor;
  QColor m_lineColorDefault;
  QColor m_fontIndexColor;
  QColor m_fontIndexColorDefault;
  uint m_fontSize;
  uint m_fontSizeDefault;
  QColor m_userImageColor;
  QColor m_userImageColorDefault;
  QColor m_userNameColor;
  QColor m_userNameColorDefault;
  QColor m_sepNameColor;
  QColor m_sepNameColorDefault;

  /* history */
  QStringList m_plugins;

  /* layout */
  int m_facePos_x;
  int m_facePos_y;
  int m_userNamePos_x;
  int m_userNamePos_y;
  int m_searchBox_x;
  int m_searchBox_y;
  int m_searchBox_w;
  int m_searchBox_h;
  bool m_searchBox_static;
  bool m_faceBoxHideText;

  int m_listBox_x;
  int m_listBox_y;
  int m_listBox_w;
  int m_listBox_h;

  int m_itemView_x;
  int m_itemView_y;
  int m_itemView_h;
  int m_itemView_w;

  int m_topBar_x;
  int m_topBar_y;
  int m_topBar_h;
  int m_topBar_w;

  int m_botBar_x;
  int m_botBar_y;
  int m_botBar_h;
  int m_botBar_w;

  int m_scrollBarTopX;
  int m_scrollBarTopY;
  int m_scrollBarBotX;
  int m_scrollBarBotY;

  bool m_enableWater;
  int m_waterRate;

  /* toolbar */
  int m_toolBarButtonNormalSize;
  int m_toolBarButtonExpandSize;

  bool m_KbfxGlobalChange;

private:
  KbfxConfig();
  KbfxConfig(const KbfxConfig&);

friend KbfxConfig& ConfigInit();

};

KbfxConfig & ConfigInit();

#endif
