/***************************************************************************
 *   Copyright (C) 2006 by PhobosK                                         *
 *   phobosk@mail.kbfx.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KBFXCONFIGAPP_H_
#define _KBFXCONFIGAPP_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>
#include <klocale.h>
#include <kdebug.h>
#include <kurlrequester.h>
#include <kicondialog.h>
#include <dcopref.h>
#include <qvariant.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <kpushbutton.h>
#include <qtoolbox.h>
#include <qgroupbox.h>
#include <qwidgetstack.h>
#include <qtextbrowser.h>
#include <kstandarddirs.h>
#include <kactivelabel.h>
#include <khtml_part.h>
#include <khtmlview.h>
#include <kio/job.h>
#include <kio/netaccess.h>
#include <ktempfile.h>
#include <krun.h>
#include <kurl.h>
#include <ktar.h>
#include <kfiledialog.h>
#include <qmap.h>
#include <kcmdlineargs.h>
#include <kcombobox.h>
#include <qtimer.h>
#include <karchive.h>

#include <kbfxconfig.h>
#include <kbfxkiodownload.h>

#include "kbfxconfigdlgmain.h"
#include "kbfxconfigdlgbutton.h"
#include "kbfxconfigdlgthemes.h"
#include "kbfxconfigdlgabout.h"
#include "kbfxconfigdlgstyle.h"
#include "kbfxconfigdlgtooltip.h"
#include "kbfxconfigdlgfonts-old.h"
#include "kbfxthemesdata.h"

/**
 * @short Application Main Window
 * @author PhobosK <phobosk@mail.kbfx.org>
 * @version 0.1
 */

class KbfxConfigApp : public KbfxConfigDlgMain
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    KbfxConfigApp(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );

    /**
     * Default Destructor
     */
    virtual ~KbfxConfigApp();
	void InitForm();
	
	QString m_KbfxVersion;
	QString m_KbfxVersion2;
	QString m_KbfxNewsBrowserError;
	QString m_KbfxNewsBrowserAddress;
	
	void handleCliArgs();
	void browserInit();

private:
	KbfxConfigDlgButton *pageButton;
	KbfxConfigDlgThemes *pageThemes;
	KbfxConfigDlgFonts *pageFonts;
	KbfxConfigDlgStyle *pageStyle;
	KbfxConfigDlgTooltip *pageTooltip;
	KbfxConfigDlgAbout *pageAbout;
	KHTMLPart * browser;
	KbfxKioDownload * kio;
	QString m_KbfxThemeUrl;
	QString m_KbfxThemeFolderUrl;
	QString m_SpinxThemeBasePathTmp;
	QString m_SpinxThemeNameTmp;
    QString tmp_FontSpinxThemeBasePath;
    QString tmp_FontSpinxThemeName;
	bool m_FontsPage;
	bool m_PrepareOption;
	void KbfxSaveFontsConfig();
	


public slots:
	virtual void btn_DefaultClicked();
    virtual void btn_SaveApplyClicked();
	virtual void KbfxMenuItemChanged(int index);
	virtual void KbfxNewsBrowserOpenURLRequest(const KURL &, const KParts::URLArgs & );
	virtual void KbfxNewsBrowserCompleted();
    virtual void KbfxNewsBrowserLoad();
    virtual void KbfxGetMoreThemesClicked();

signals:
    void KbfxConfigDlgButtonChanged();
    void KbfxConfigDlgThemesChanged();
    void KbfxConfigDlgStyleChanged();
    void KbfxConfigDlgTooltipChanged();
    void KbfxConfigDlgFontsChanged();
    void KbfxConfigDlgFontsDefaults();
    void KbfxThemeDoInstall(QString &);

};

#endif // _KBFXCONFIGAPP_H_
