/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef KBFXSPINXLISTBOX_H
#define KBFXSPINXLISTBOX_H

#include <qlistbox.h>
#include <qwidget.h>
#include <qevent.h>
#include <qapplication.h>
#include <qcursor.h>
#include "vistalistbox.h"



class KbfxSpinxListBox:public QListBox
{

Q_OBJECT public:


KbfxSpinxListBox (QWidget * parent = 0, const char *name = 0, WFlags flags = 0):QListBox (parent, name/*,Qt::WStaticContents | Qt::WNoAutoErase*/)
  {

    scrollIndex = 5;
    blocked = 1;
    this->setVScrollBarMode (QScrollView::AlwaysOff);
    parentRef = parent;
    scrolllen = 0;
    _type = 0;
    _selected = new QPoint (0, 0);
    _clickCount = 0;
    _lastIndex = 0;
    _sepCount =0;
//	viewport()->setDragAutoScroll ( true ); 
	viewport()->setAcceptDrops(true);
  }


  void setMouseMode (int b)
  {

    blocked = b;

  }

  void setType (int type)
  {
    _type = type;
	_sepCount++;
  //printf("sep count %d\n",_sepCount);
  }
 
  int sepCount(){
			return _sepCount;
		}

  int getType(){ return _type;}
void scrollNeeded()
{
	if ((this->count() - sepCount() ) > 5)
		emit showScrollBar();
	else
		emit hideScrollBar();
}

 void setTopActive()
{

 VistaListBoxItem * __item = (VistaListBoxItem*) this->firstItem();
if (__item == NULL)
	return;
else
 clearAllButOne(__item);



}


signals:
  void test (QListBoxItem *);
  void raiseNow (int);
  void showScrollBar(void);
  void hideScrollBar(void);
  void dragDone(QListBoxItem*);
  public slots:
  void scrollRest (int);
  void scroll (int);

protected:
//virtual void paintEvent(QPaintEvent *event);
//virtual void timerEvent(QTimerEvent *event);
//virtual void hideEvent(QHideEvent *event);
  virtual void leaveEvent (QEvent *);
  virtual void contentsMousePressEvent(QMouseEvent *event);
  virtual void contentsMouseMoveEvent(QMouseEvent *event);
  virtual void dragLeaveEvent (QDragLeaveEvent *);

  virtual void dragMoveEvent (QDragMoveEvent *);

  virtual void mouseMoveEvent (QMouseEvent * e);

  virtual void showEvent(QShowEvent * e)
	{
	e = e;
	scrollNeeded();
	}

  virtual void wheelEvent (QWheelEvent * e);

  virtual void mouseReleaseEvent (QMouseEvent * e)
  {

    VistaListBoxItem *_item = (VistaListBoxItem *) this->itemAt (e->pos ());
    if (_item == NULL)
      return;
    *_selected = e->pos ();

    this->clearSelection ();
    _item->block (1);
    this->setCurrentItem (_item);
    this->clearAllButOne (_item);
    emit raiseNow (this->index (_item));
    emit clicked (_item);
    return;
  }


  virtual void enterEvent (QEvent * e)
  {
     //	this->scrollNeeded();

	e = e;
    VistaListBoxItem *_item = (VistaListBoxItem *) this->itemAt (*_selected);
    if (_item == NULL)
      return;

    this->clearSelection ();
//this->clearAllButOne(_item);
  }

  void clearBlock ()
  {

    if (!_type)
      return;
    int _m_count = this->count ();

    for (; _m_count >= 0; _m_count--)
      {

	VistaListBoxItem *__item__ =
	  (VistaListBoxItem *) this->item (_m_count);
	if (__item__ == NULL)
	  continue;
	__item__->block (0);
      }

  }

   void clearAllButOne (VistaListBoxItem * item)
  {
    if (!_type)
      return;
    int _m_count = this->count ();

    for (; _m_count >= 0; _m_count--)
      {

	VistaListBoxItem *__item__ =
	  (VistaListBoxItem *) this->item (_m_count);
	if (__item__ == NULL || __item__ == item)
	  continue;
	__item__->block (0);
	this->updateItem (__item__);
      }



  }

void startDrag(VistaListBoxItem * );



private:
  int m_x;
  int m_y;
  int scrollIndex;
  int blocked;
  VistaListBoxItem *_lastItem;
  QWidget *parentRef;
  int scrolllen;
  int _type;
  QPoint *_selected;
  QPoint m_dragPos;
  int _lastIndex;
  int _clickCount;
  int _sepCount;

};


#endif
