/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "vistalistbox.h"
#include <qimage.h>
#include <qpixmap.h>
#include <qtimer.h>
#include "../imagesource/listboxtile.xpm"
#include "../imagesource/listboxhover.xpm"
#include "../imagesource/menuright.xpm"







void
VistaListBoxItem::paint (QPainter * painter)
{
/**
Note:: all these are just crazy code
since we dont want to spend too much
time with 0.4.9. all this will
be replaced when we write 0.5..
should be lot cleaner!
**/
//CLEAN THIS MESS ANY ONE!

	itemHeight = listImageNormal.height ();
	bool in_list_box = listBox ()
		&& listBox ()->viewport () == painter->device ();
	
	QRect r (0, 0, width (listBox ()), height (listBox ()));
	painter->drawPixmap (r, listImageNormal);
	painter->drawPixmap (5, 6, iconPixmap,
			0, 0, iconPixmap.height (), iconPixmap.width ());
	
	QFont *let = new QFont ();
	if (!type)
		let->setBold (FALSE);
	else
		let->setBold (FALSE);
	
	let->setPointSize (ConfigInit().m_fontSize);
	
	int _applicationTextHeight;
	if (type)
		_applicationTextHeight = let->pointSize () / 2;
	else
		_applicationTextHeight = let->pointSize () + 1;


	if(type)
	{
		painter->setPen (ConfigInit().m_fontIndexColor);
	}
	else
	{
		painter->setPen (ConfigInit().m_fontAppNameColor);
	}
  
  	painter->setFont (*let);

 	if(type == 3)
		painter->setPen(ConfigInit().m_sepNameColor);

 
	if(!type)
	{
/*		
		painter->drawText (iconPixmap.width () + 10, 0,
				width (listBox ()), height (listBox ())/2,
			 	Qt::SingleLine|Qt::AlignAuto| Qt::AlignVCenter,
			 	*text);
	
		painter->drawText (iconPixmap.width () + 10,
				(height (listBox ()) - iconPixmap.height())/2,
				width (listBox ()), iconPixmap.height()/2,
			 	Qt::SingleLine|Qt::AlignAuto| Qt::AlignVCenter,
			 	*text);
		
		painter->drawText (iconPixmap.width () + 10, (height (listBox ())/2)-16,
				width (listBox ()), 16,
			 	Qt::SingleLine|Qt::AlignAuto| Qt::AlignVCenter,
			 	*text);
*/	
		painter->drawText (iconPixmap.width () + 10, 0,
				width (listBox ()), (height (listBox ())/2)-2,
			 	Qt::SingleLine|Qt::AlignAuto| Qt::AlignBottom,
			 	*text);
	}
	else
	{
		painter->drawText (iconPixmap.width () + 10, 0,
				width (listBox ()), height (listBox ()),
				Qt::SingleLine|Qt::AlignAuto|Qt::AlignVCenter,
				*text);
	}


  	if (!type)
    	{
      		painter->setPen (ConfigInit().m_lineColor);
 		if(type == 3)
			painter->setPen(ConfigInit().m_sepNameColor);
/*      		
      		painter->drawLine (iconPixmap.width () + 10,
      				listImageNormal.height () / 2,
      				200, listImageNormal.height () / 2);
*/      		
      		painter->drawLine (iconPixmap.width () + 10,
      				height (listBox ())/2,
      				200, height (listBox ())/2);
    	}


	painter->setPen (ConfigInit().m_fontAppCommentColor);
	let->setBold (FALSE);
	let->setPointSize (ConfigInit().m_fontSize);
	painter->setFont (*let);
/*	
	painter->drawText (iconPixmap.width () + 10, height (listBox ())/2,
		     width (listBox ()), height (listBox ())/2,
		     Qt::SingleLine|Qt::AlignAuto| Qt::AlignVCenter,
		     application_comment);
	
	painter->drawText (iconPixmap.width () + 10,
		     height (listBox ())/2,
		     width (listBox ()), iconPixmap.height()/2,
		     Qt::SingleLine|Qt::AlignAuto| Qt::AlignVCenter,
		     application_comment);
	
	painter->drawText (iconPixmap.width () + 10, height (listBox ())/2,
		     width (listBox ()), 16,
		     Qt::SingleLine|Qt::AlignAuto| Qt::AlignVCenter,
		     application_comment);
*/	
	painter->drawText (iconPixmap.width () + 10, (height (listBox ())/2)+2,
		     width (listBox ()), (height (listBox ())/2)-2,
		     Qt::SingleLine|Qt::AlignAuto| Qt::AlignTop,
		     application_comment);

	if ((_blocked == 1 && type) || (in_list_box && isCurrent ()))
	{
	      painter->drawPixmap (r, listImageMouseOver);
	      if (!iconPixmap.isNull ())
		{
		  QPixmap tmp = iconPixmap;
		  QImage zoom = iconPixmap.convertToImage ();
		  zoom = zoom.smoothScale (36, 36);
		  iconPixmap.convertFromImage (zoom);
		  painter->drawPixmap (5, 6, iconPixmap, 0, 0,
		  		zoom.height (),
				zoom.width ());
		  iconPixmap = tmp;
		}
//	      painter->drawText (iconPixmap.width () + 10, 5, width (listBox ()),
//	                       height (listBox ()), Qt::SingleLine, *text);
	
	      let->setBold (TRUE);
	      let->setPointSize (ConfigInit().m_fontSize);
	      painter->setFont (*let);
	
	      painter->setPen (ConfigInit().m_fontAppNameColor);
	
	      if (type)
		{
		  painter->setPen(ConfigInit().m_fontIndexColor);
	      	  if(type == 3)
		    {
		      painter->setPen(ConfigInit().m_sepNameColor);
		      let->setBold (FALSE);
		      painter->setFont (*let);
		    }
	      
	          painter->drawText (iconPixmap.width () + 10, 0,
	      			width (listBox ()), height (listBox ()),
	      			Qt::SingleLine|Qt::AlignAuto|Qt::AlignVCenter,
	      			*text);
		}
	      else
		{
/*		  
		  painter->drawText (iconPixmap.width () + 12, 0,
				     width (listBox ()), height (listBox ())/2,
				     Qt::SingleLine|Qt::AlignAuto|Qt::AlignVCenter,
				     *text);
		  
		  painter->drawText (iconPixmap.width () + 12,
		  		     (height (listBox ()) - iconPixmap.height())/2,
				     width (listBox ()), iconPixmap.height()/2,
				     Qt::SingleLine|Qt::AlignAuto|Qt::AlignVCenter,
				     *text);
		  
		  painter->drawText (iconPixmap.width () + 12, (height (listBox ())/2)-16,
				     width (listBox ()), 16,
				     Qt::SingleLine|Qt::AlignAuto|Qt::AlignVCenter,
				     *text);
*/		  
		  painter->drawText (iconPixmap.width () + 12, 0,
				     width (listBox ()), (height (listBox ())/2)-2,
				     Qt::SingleLine|Qt::AlignAuto|Qt::AlignBottom,
				     *text);
		}
	
	      if (!type)
		{
		  painter->setPen (ConfigInit().m_lineColor);
	
/*		  
		  painter->drawLine (iconPixmap.width () + 12,
				     listImageNormal.height () / 2,
				     200, listImageNormal.height () / 2);
*/		  
		  painter->drawLine (iconPixmap.width () + 12,
				     height (listBox ())/2,
				     200, height (listBox ())/2);
	
		  painter->setPen (ConfigInit().m_fontAppCommentColor);
	
/*		  
		  painter->drawText (iconPixmap.width () + 12, height (listBox ())/2,
		  		width (listBox ()), height (listBox ())/2,
		  		Qt::SingleLine|Qt::AlignAuto| Qt::AlignVCenter,
		  		application_comment);
		  
		  painter->drawText (iconPixmap.width () + 12,
		  	        height (listBox ())/2,
		  		width (listBox ()), iconPixmap.height()/2,
		  		Qt::SingleLine|Qt::AlignAuto| Qt::AlignVCenter,
		  		application_comment);
		  
		  painter->drawText (iconPixmap.width () + 12, height (listBox ())/2,
		  		width (listBox ()), 16,
		  		Qt::SingleLine|Qt::AlignAuto| Qt::AlignVCenter,
		  		application_comment);
*/		  
		  painter->drawText (iconPixmap.width () + 12, (height (listBox ())/2)+2,
		  		width (listBox ()), (height (listBox ())/2)-2,
		  		Qt::SingleLine|Qt::AlignAuto| Qt::AlignTop,
		  		application_comment);
		}
	
	}
	delete let;
}

void
VistaListBoxItem::setLabelText (QString * name)
{
/*	text = new QString(*name);
	if (text->length() > 22)
	{
		text->setLength(22);
		text->append("...");
	}
	else if ( text->length() == 0)
	{
		text->append("UNKNOWN APPLICATION");
	}

//	text = name;
*/
	text = name;
	if ((*text).length() > 22)
	{
		(*text).setLength(22);
		(*text) += "..." ;
	}
	else if ( (*text).length() == 0)
	{
		(*text) = "UNKNOWN APPLICATION";
	}
}

void
VistaListBoxItem::setLabelIcon (QPixmap icon)
{

  iconPixmap = icon;

}


void
VistaListBoxItem::setLabelIcon (QString icon)
{
  application_icon = icon;
  setLabelIcon (QPixmap (icon));
}

void
VistaListBoxItem::setHeight (int h)
{

  itemHeight = h;

}

void
VistaListBoxItem::setWidth (int w)
{

  itemWidth = w;

}

void
VistaListBoxItem::setApplicationProperties (QString appname, QString exename,
					    QString desktopfile)
{

  application_name = new QString (appname);
  application_exe = (exename);
  application_desktop_file = new QString (desktopfile);
}



QPixmap 
VistaListBoxItem::drawDragPixmap()
{
QPixmap img = listImageMouseOver;
QPainter painter;
QFont *let = new QFont ();
  int _applicationTextHeight;	// +(let->pixelSize()*2);
  let->setBold (FALSE);
  let->setPointSize (ConfigInit().m_fontSize);

  if (type)
    _applicationTextHeight = let->pointSize () / 2;
  else
    _applicationTextHeight = let->pointSize () + 1;




painter.begin(&img);
  painter.setFont(*let);
  painter.drawPixmap (5, 6, iconPixmap, 0, 0, iconPixmap.height (),
		       iconPixmap.width ());



    if (type)
	{
	
	if(text == NULL)
		qDebug("Text painting failed null");
	  painter.drawText (iconPixmap.width () + 10, _applicationTextHeight,
			     width (listBox ()), height (listBox ()),
			     Qt::SingleLine, *text);



	}
      else
	{

	  painter.drawText (iconPixmap.width () + 12, _applicationTextHeight,
			     width (listBox ()), height (listBox ()),
			     Qt::SingleLine, *text);


	}


  painter.setPen (ConfigInit().m_lineColor);

          painter.drawLine (iconPixmap.width () + 12,
                             listImageNormal.height () / 2, 200,
                             listImageNormal.height () / 2);

          painter.setPen (ConfigInit().m_fontAppCommentColor);

          painter.drawText (iconPixmap.width () + 12,
                             (_applicationTextHeight + let->pointSize () +
                              10), width (listBox ()), height (listBox ()),
                             Qt::SingleLine, "Relocating...");




painter.end();

return img;

}




void
VistaListBoxItem::setTilePixmap (QPixmap tile)
{

  if (tile.isNull ())
    {
      //  qDebug ("Tile Image is NULL:using built in resources");
      QImage tileimg (listboxtile_xpm);
      QPixmap tilepixmap (tileimg);
      listImageNormal = tileimg;
    }
  else
    {
      listImageNormal = tile;
    }

}

void
VistaListBoxItem::setTileHoverPixmap (QPixmap hovertile)
{
  if (hovertile.isNull ())
    {
// qDebug ("Tile Image is NULL:using built in resources");
      QImage tileimg (listboxhover);
      QPixmap tilepixmap (tileimg);
      listImageMouseOver = tileimg;
    }
  else
    {
      listImageMouseOver = hovertile;
    }
}
