package org.kde.koala;
import org.kde.qt.*;
import java.util.Calendar;

/** {@link KDatePicker} emits these signals */
public interface KDatePickerSignals {

/**  This signal is emitted each time the selected date is changed. 
      Usually, this does not mean that the date has been entered,
      since the date also changes, for example, when another month is
      selected. 

*/
	void dateSelected( Calendar arg1 );

/**  This signal is emitted when enter is pressed and a VALID date
      has been entered before into the line edit. Connect to both
      dateEntered() and dateSelected() to receive all events where the 
      user really enters a date. 
*/
	void dateEntered( Calendar arg1 );
	void destroyed();

/**  This signal is emitted when the day has been selected by
      clicking on it in the table. 
*/
	void tableClicked();
}

