import org.kde.qt.*;

public class CannonField extends QWidget {
	private int ang;
	
	public CannonField(QWidget parent, String name) {
		super(parent, name);
		ang = 45;
		setPalette(new QPalette(new QColor(250, 250, 200)));
	}

	public int angle() {
		return ang;
	}

	public void setAngle(int degrees) {
		if (degrees < 5)
			degrees = 5;
		if (degrees > 70)
			degrees = 70;
		if (ang == degrees)
			return;
		ang = degrees;
		repaint();
		emit("angleChanged", ang);
	}

	public void paintEvent(QPaintEvent e) {
		String s = "Angle = " + ang;
		QPainter p = new QPainter(this);
		p.drawText(200, 200, s);
	}

	public QSizePolicy sizePolicy() {
		return new QSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding);
	}
}
