/***************************************************************************
                          changelog.h  -  description
                             -------------------
    begin                : Sat Feb 14 2003
    copyright            : (C) 2003 by Simone Gotti
    email                : simone.gotti@email.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHANGELOG_H
#define CHANGELOG_H

#include <qwidget.h>
#include <qcstring.h>
#include <qtextstream.h>
#include <qstringlist.h>


class Changelog : public QObject
{
	Q_OBJECT
	
public:

	enum SyncAnchor {
	    ChangeCounters,
		TimeStamps
	};

	class record
	{
	public:

		record();
		~record();
		
		QString changeCounter();
		QString timeStamp();
		QString LUID();
	
		bool isModified();
		bool isDeleted();
		bool isHardDeleted();

	private:
		QString mChangeCounter;
		QString mTimeStamp;
		QString mLUID;

		bool mIsModified;
		bool mIsDeleted;
		bool mIsHardDeleted;
		
		friend class Changelog;

	};


	Changelog(QByteArray&, SyncAnchor type, QWidget *parent=0, const char *name=0);
	~Changelog();

	bool meta();

	QValueList<record> recordsList();
	QString serialNumber();
	QString databaseId();
	
protected slots:

signals:

protected:

	void getSerialNumber();
	void getDatabaseId();

	void getChangelogRecords();
	void getModifiedRecords();
	void getDeletedRecords();
	void getHardDeletedRecords();
	
	void createReducedChangelog();

	QByteArray& changelog;
	QTextStream* changelogStream;
	QStringList changelogStrings;

	QString mSerialNumber;
	QString mDatabaseId;

	QValueList<record> mRecordsList;
	bool getAllRecords;
	
	uint SyncAnchorType;
	
};

#endif // CHANGELOG_H
