//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PAIREDTAB_H
#define PAIREDTAB_H

#include "pairedtabbase.h"
#include <qcstring.h>
#include <qdatastream.h>
#include <qstringlist.h>
#include <libkbluetooth/deviceaddress.h>
#include <qdatetime.h>
#include <vector>

class DCOPClient;
class KDirWatch;
class FileSettingsBase;

/**
@author Fred Schaettgen
*/
class PairedTab : public PairedTabBase
{
Q_OBJECT
public:
    PairedTab(QWidget *parent, const char* name);
    ~PairedTab();
    void apply();
    void defaults();
signals:
    void dirty();
private:
    struct PairingInfo {
        KBluetooth::DeviceAddress localAddr;
        KBluetooth::DeviceAddress remoteAddr;
        QString remoteName;
        int remoteClass;
        uint8_t linkKey[16];
        uint8_t type;
        QDateTime time;
        QListViewItem *listViewItem;
    };
    std::vector<PairingInfo> pairingList;
    bool linkKeyFileValid;
    bool bDirty;
    
    QString linkKeyFilename;
    QString hcidStartCommand;
    QString hcidStopCommand;
    KDirWatch *linkKeyFileWatch;
    FileSettingsBase *fileSettingsDialog;
    
    void reloadList();
    bool saveList();
    bool startDaemon();
    bool stopDaemon();
    void updateGUI();
    
private slots:
    void slotKeyFileChanged();
    void slotRemovePairing();
    void slotSelectionChanged();
    void slotFileSettings();
    void slotApplyFileSettings();

};

#endif
