/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef DEVICE_CLASS_H
#define DEVICE_CLASS_H

#include <string.h>
#include <stdlib.h>
#include <stdint.h>

#define CLASS_COMPUTER \
"Uncategorized," \
"Desktop workstation," \
"Server," \
"Laptop," \
"Handheld," \
"Palm," \
"Wearable"

#define CLASS_COMPUTER_VALUES { 0*4, 1*4, 2*4, 3*4, 4*4, 5*4, 6*4 }
static const uint8_t class_computer_values[7] = CLASS_COMPUTER_VALUES;
#define CLASS_COMPUTER_COUNT 7

#define CLASS_PHONE \
"Uncategorized," \
"Cellular," \
"Cordless," \
"Smart phone," \
"Wired modem or voice gateway," \
"Common ISDN Access," \
"Sim Card Reader"

#define CLASS_PHONE_VALUES { 0*4, 1*4, 2*4, 3*4, 4*4, 5*4, 6*4 }
static const uint8_t class_phone_values[7] = CLASS_PHONE_VALUES;
#define CLASS_PHONE_COUNT 7

#define CLASS_LAN_ACCESS \
"Uncategorized," \
"Fully available," \
"1-17% utilized," \
"17-33% utilized," \
"33-50% utilized," \
"50-67% utilized," \
"67-83% utilized," \
"83-99% utilized," \
"No service available"

#define CLASS_LAN_ACCESS_VALUES { 0, 1, 1*8*4, 2*8*4, 3*8*4, 4*8*4, 5*8*4, 6*8*4, 7*8*4 }
static const uint8_t class_lan_access_values[9] = CLASS_LAN_ACCESS_VALUES;
#define CLASS_LAN_ACCESS_COUNT 9

#define CLASS_AUDIO_VIDEO \
"Uncategorized," \
"Device conforms to the Headset profile," \
"Hands-free," \
"Microphone," \
"Loudspeaker," \
"Headphones," \
"Portable Audio," \
"Car Audio," \
"Set-top box," \
"HiFi Audio Device," \
"VCR," \
"Video Camera," \
"Camcorder," \
"Video Monitor," \
"Video Display and Loudspeaker," \
"Video Conferencing," \
"Gaming/Toy"

#define CLASS_AUDIO_VIDEO_VALUES \
{ 0*4, 1*4, 2*4, 4*4, 5*4, 6*4, 7*4, 8*4, \
9*4, 10*4, 11*4, 12*4, 13*4, 14*4, 15*4, 16*4, 18*4 }
static const uint8_t class_audio_video_values[17] = CLASS_AUDIO_VIDEO_VALUES;
#define CLASS_AUDIO_VIDEO_COUNT 17

#define CLASS_PERIPHERAL \
"Keyboard," \
"Pointing device," \
"Combo keyboard/pointing device"

#define CLASS_PERIPHERAL_VALUES { 16*4, 32*4, 48*4 }
static const uint8_t class_peripheral_values[3] = CLASS_PERIPHERAL_VALUES;
#define CLASS_PERIPHERAL_COUNT 3

#define CLASS_IMAGING \
"Display," \
"Camera," \
"Scanner," \
"Printer," \
"Uncategorised"

#define CLASS_IMAGING_VALUES { 4*4, 8*4, 16*4, 32*4 }
static const uint8_t class_imaging_values[4] = CLASS_IMAGING_VALUES;
#define CLASS_IMAGING_COUNT 4

class DeviceClass {

public: 
    DeviceClass();
    ~DeviceClass();
    static const char* get_minors(int major);
    static const uint8_t* get_minor_vals(int major,int* count);
    static const uint8_t get_minor_value(int major, int ord);
    static const uint8_t getServicesMask(int* services,int count);
//    void xxx(uint8_t* s, const uint8_t* d);
};

#endif /* DEVICE_CLASS_H */
