//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KBLUETOOTHDNAMECACHE_H
#define KBLUETOOTHDNAMECACHE_H

#include <qobject.h>

class DCOPClient;

namespace KBluetooth {

class DeviceAddress;

namespace NameCache
{

bool getCachedName(const KBluetooth::DeviceAddress& addr, 
    QString& name, DCOPClient* dc = NULL);
bool getCachedClass(const KBluetooth::DeviceAddress& addr, 
    int& devClass, DCOPClient* dc = NULL);
bool resolveCachedName(const QString& name, 
    KBluetooth::DeviceAddress& addr, DCOPClient* dc = NULL);

}
}

#endif
