/*
 *  This file is part of the KDE libraries
 *  Copyright (C) 2000-2001 Harri Porten (porten@kde.org)
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _KJS_DEBUGGER_H_
#define _KJS_DEBUGGER_H_

#ifdef KJS_DEBUGGER

#include <qwidget.h>
#include <qintdict.h>
#include <kjs/debugger.h>

class QMultiLineEdit;
class KJScript;

class KJSDebugWin : public QWidget, public KJS::Debugger {
  Q_OBJECT
public:
  KJSDebugWin(QWidget *parent=0, const char *name=0);
  ~KJSDebugWin();

  void setCode(const QString &code);
  void highLight(int line);

public slots:
  void next();
  void step();
  void cont();

protected:
  virtual bool stopEvent();

private:
  void enterSession();
  void leaveSession();

  bool modal;
  QMultiLineEdit *edit;
  QPushButton *stepButton, *nextButton, *continueButton;
  QIntDict<QString> srcDict;
  int currentSrcId;
};

#endif

#endif
