/***************************************************************************
                          strength.cpp  -  description
                             -------------------
    begin                : Mon Aug 19 2002
    copyright            : (C) 2002 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qwidget.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include "strength.h"
#include "interface_wireless.h"

extern bool useAlternateStrengthCalc;

Strength::Strength (QWidget * parent, Interface_wireless * device):QWidget (parent,
	 "strength")
{
  this->device = device;
  KStandardDirs finder;
  kdedir = finder.findResourceDir ("data", "kwifimanager/pics/no_card.png");
  kdedir += "kwifimanager/pics/";
  NOT_CON_OFFLINE_ADHOC = new QPixmap (kdedir + "offline.png");
  EXCELLENT = new QPixmap (kdedir + "excellent.png");
  GOOD = new QPixmap (kdedir + "good.png");
  MARGINAL = new QPixmap (kdedir + "marginal.png");
  OOR_MINIMUM = new QPixmap (kdedir + "oor_minimum.png");
  OOR_DOWN = new QPixmap (kdedir + "oor_down.png");
}

Strength::~Strength ()
{
  delete NOT_CON_OFFLINE_ADHOC;
  delete GOOD;
  delete MARGINAL;
  delete OOR_MINIMUM;
  delete OOR_DOWN;
}

void
Strength::paintEvent (QPaintEvent * event)
{
  updateInfo (event);
}

void
Strength::updateInfo (QPaintEvent *)
{
  QPainter *strengthpainter = new QPainter (this);
  sstrength1 = "%1";
  int sig, noi, strength;
  double freq;
  bool validdata = device->get_current_quality (sig, noi, strength);
  if (useAlternateStrengthCalc) strength = sig - noi;
  int mode;
  sstrength2 = "%1";
  if (!device->get_device_freq (freq))
    {
      sstrength1 = sstrength1.arg (i18n ("NOT CONNECTED"));
      sstrength2 = sstrength2.arg (i18n ("N/A"));
      strengthpainter->drawPixmap (50, 10, *NOT_CON_OFFLINE_ADHOC);
    }
  else if (device->get_mode(mode) && mode == 1)
    {
      sstrength1 = sstrength1.arg (i18n ("AD-HOC MODE"));
      sstrength2 = sstrength2.arg (i18n ("N/A"));
      strengthpainter->drawPixmap (50, 10, *NOT_CON_OFFLINE_ADHOC);
    }
  else if (validdata && (strength > 45))
    {
      sstrength1 = sstrength1.arg (i18n ("ULTIMATE"));
      sstrength2 = sstrength2.arg (strength);
      strengthpainter->drawPixmap (50, 10, *EXCELLENT);
    }
  else if (validdata && (strength > 35))
    {
      sstrength1 = sstrength1.arg (i18n ("TOP"));
      sstrength2 = sstrength2.arg (strength);
      strengthpainter->drawPixmap (50, 10, *EXCELLENT);
    }
  else if (validdata && (strength > 25))
    {
      sstrength1 = sstrength1.arg (i18n ("EXCELLENT"));
      sstrength2 = sstrength2.arg (strength);
      strengthpainter->drawPixmap (50, 10, *EXCELLENT);
    }
  else if (validdata && (strength > 15))
    {
      sstrength1 = sstrength1.arg (i18n ("GOOD"));
      sstrength2 = sstrength2.arg (strength);
      strengthpainter->drawPixmap (50, 10, *GOOD);
    }
  else if (validdata && (strength > 5))
    {
      sstrength1 = sstrength1.arg (i18n ("WEAK"));
      sstrength2 = sstrength2.arg (strength);
      strengthpainter->drawPixmap (50, 10, *MARGINAL);
    }
  else if (validdata && (strength > 0))
    {
      sstrength1 = sstrength1.arg (i18n ("MINIMUM"));
      sstrength2 = sstrength2.arg (strength);
      strengthpainter->drawPixmap (50, 10, *OOR_MINIMUM);
    }
  else if (((strength == 0) && (mode == 2)) || (!validdata))
    {
      sstrength1 = sstrength1.arg (i18n ("OUT OF RANGE"));
      sstrength2 = sstrength2.arg ("0");
      strengthpainter->drawPixmap (50, 10, *OOR_DOWN);
    }
  else
    {
      sstrength1 = sstrength1.arg (i18n ("N/A"));
      sstrength2 = sstrength2.arg ("N/A");
      strengthpainter->drawPixmap (50, 10, *NOT_CON_OFFLINE_ADHOC);
    };
  sstrength2 = i18n ("Signal strength: ") + sstrength2;
  strengthpainter->drawText (5, 50, sstrength1);
  strengthpainter->drawText (5, 70, sstrength2);
  delete strengthpainter;
}

#include "strength.moc"
