/***************************************************************************
                          propsview.cpp  -  description
                             -------------------
    begin                : Tue May 1 2001
    copyright            : (C) 2001 by Richard Moore
    email                : rich@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qobjcoll.h>
#include <qmetaobject.h>
#include <qstrlist.h>
#include <qvariant.h>

#include "propsview.h"

PropsView::PropsView(QWidget *parent, const char *name ) : QListView(parent,name)
{
  addColumn( "Name" );
  addColumn( "Value" );
  addColumn( "Type" );
  addColumn( "Access" );
  addColumn( "Designable" );
  addColumn( "Type Flags" );

  setAllColumnsShowFocus( true );
  setColumnAlignment( 3, AlignCenter );
  setColumnAlignment( 4, AlignCenter );
}

PropsView::~PropsView()
{
}

void PropsView::buildList( QObject *o )
{
  QMetaObject *mo = o->metaObject();
  QStrList names = mo->propertyNames( true );

  for ( uint i = 0; i < names.count(); i++ ) {
    char *prop = names.at( i );
    QVariant v = o->property( prop );

    QString val( "????" );
    switch( v.type() ) {
       case QVariant::String:
       case QVariant::CString:
         val = v.toString();
         break;
       case QVariant::Bool:
         val = ( v.toBool() ? "True" : "False" );
         break;
       case QVariant::Int:
         val.setNum( v.toInt() );
         break;
       case QVariant::Double:
         val.setNum( v.toDouble() );
         break;
       default:
         break;
    }

    QString ro("R/O");
    QString rw("R/W");
    QString st("Set");
    QString et("Enum");
    QString yes("Yes");
    QString no("No");

    const QMetaProperty *mp = mo->property( prop, true );
    QString writable = ( mp->writable() ? rw : ro );
    QString setType = ( mp->isSetType() ? st : QString::null );
    QString enumType = ( mp->isEnumType() ? et : QString::null );
    QString designable = ( mp->designable() ? yes : no );

    QString flags;
    bool first = true;
    if ( !setType.isNull() ) {
      if ( first )
        first = false;
      else
        flags += " | ";

      flags += setType;
    }
    if ( !enumType.isNull() ) {
      if ( first )
        first = false;
      else
        flags += " | ";

      flags += enumType;
    }

    new QListViewItem( this, prop, val, v.typeName(), writable, designable, flags );
  }
}

void PropsView::setTarget( QObject *o )
{
  clear();
  buildList( o );
}
#include "propsview.moc"
