/***************************************************************************
                          kscribbledoc.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Jul 30 11:28:26 CEST 1999
                                           
    copyright            : (C) 1999 by Ralf Nolden                         
    email                : Ralf.Nolden@post.rwth-aachen.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>

// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>

// application specific includes
#include <kscribbledoc.h>
#include "kscribble.h"
#include "kscribbleview.h"

QList<KScribbleView>* KScribbleDoc::viewList = 0L;

KScribbleDoc::KScribbleDoc(QWidget *parent, const char* name):QObject(parent, name)
{
	if( !viewList )
		viewList = new QList<KScribbleView>;
	viewList->setAutoDelete(true);
}

KScribbleDoc::~KScribbleDoc()
{
}

void KScribbleDoc::addView(KScribbleView* m_pView)
{
	viewList->append(m_pView);
}

void KScribbleDoc::removeView(KScribbleView* m_pView)
{
	viewList->remove(m_pView);
}
const QString& KScribbleDoc::getPathName() const
{
	return m_path;
}

void KScribbleDoc::slotUpdateAllViews(KScribbleView* pSender)
{
	KScribbleView* w;
	if(viewList)
	{
		for( w = viewList->first(); w; w = viewList->next() )
		{ if( w != pSender)
				w->repaint();
		}
	}

}

void KScribbleDoc::pathName( const char* path_name)
{
	m_path=path_name;
}
void KScribbleDoc::title( const char* title)
{
	m_title=title;
}

const QString& KScribbleDoc::getTitle() const
{
	return m_title;
}

bool KScribbleDoc::saveModified()
{
	if(b_modified)
	{
		KScribbleApp* win=(KScribbleApp*) parent();
  	int want_save = KMsgBox::yesNoCancel(win,
  									i18n("Warning"),	i18n("The current file has been modified.\nDo you want to save it?"));
   	switch(want_save)
    {
    	case 1:
    		if(m_title == "Untitled")
    			win->slotFileSaveAs();
    		else
	     		saveDocument(getPathName()+getTitle());
       	
       	deleteContents();
        return true;
        break;
  		case 2:
    		setModified(false);
      	deleteContents();
  			return true;
  			break;	
  		case 3:
  			return false;
  			break;
  		default:
  			return false;
  			break;
  	}
	}
	else
		return true;

}

void KScribbleDoc::closeDocument()
{
	deleteContents();
}

bool KScribbleDoc::newDocument()
{
	
	/////////////////////////////////////////////////
	// TODO: Add your document initialization code here
	/////////////////////////////////////////////////
	b_modified=false;
	m_path=QDir::homeDirPath();
	m_title="Untitled";
	return true;
}

bool KScribbleDoc::openDocument(const char* filename, const char* format)
{
	QFileInfo fileInfo(filename);
	m_title=fileInfo.fileName();
	m_path=fileInfo.absFilePath();	
	/////////////////////////////////////////////////
	// TODO: Add your document opening code here
	/////////////////////////////////////////////////
	
	b_modified=false;
	return true;
}

bool KScribbleDoc::saveDocument(const char* filename, const char* format)
{

	/////////////////////////////////////////////////
	// TODO: Add your document saving code here
	/////////////////////////////////////////////////

	b_modified=false;
	return true;
}

void KScribbleDoc::deleteContents()
{
	/////////////////////////////////////////////////
	// TODO: Add implementation to delete the document contents
	/////////////////////////////////////////////////

}





























