__all__=('EnumOption',)
import string
import SCons.Errors
def _validator(key, val, env, vals):
    if not val in vals:
        raise SCons.Errors.UserError(
            'Invalid value for option %s: %s' % (key, val))
def EnumOption(key, help, default, allowed_values, map={}, ignorecase=0):
    """ """
    help='%s (%s)' % (help, string.join(allowed_values, '|'))
    if ignorecase >= 1:
        validator=lambda key, val, env, vals=allowed_values: \
                    _validator(key, string.lower(val), env, vals)
    else:
        validator=lambda key, val, env, vals=allowed_values: \
                    _validator(key, val, env, vals)
    if ignorecase==2:
        converter=lambda val, map=map: \
                    string.lower(map.get(string.lower(val), val))
    elif ignorecase==1:
        converter=lambda val, map=map: \
                    map.get(string.lower(val), val)
    else:
        converter=lambda val, map=map: \
                    map.get(val, val)
    return (key, help, default, validator, converter)
