import cPickle
import os
import os.path
import time
import SCons.Node
import SCons.Sig
import SCons.Warnings
sig_files=[]
database=None
def write():
    global sig_files
    for sig_file in sig_files:
        sig_file.write()
class Base:
    """ """
    def __init__(self, module=None):
        """ """
        self.module=module or SCons.Sig.default_calc.module
        self.entries={}
        self.dirty=0
    def get_entry(self, filename):
        """ """
        return self.entries[filename]
    def set_entry(self, filename, obj):
        """ """
        self.entries[filename]=obj
        self.dirty=1
class DB(Base):
    """ """
    def __init__(self, dir, module=None):
        Base.__init__(self, module)
        self.dir=dir
        try:
            global database
            rawentries=database[self.dir.path]
        except KeyError:
            pass
        else:
            try:
                self.entries=cPickle.loads(rawentries)
                if type(self.entries) is not type({}):
                    self.entries={}
                    raise TypeError
            except KeyboardInterrupt:
                raise
            except:
                SCons.Warnings.warn(SCons.Warnings.CorruptSConsignWarning,
                                    "Ignoring corrupt sconsign entry : %s"%self.dir.path)
        global sig_files
        sig_files.append(self)
    def write(self):
        if self.dirty:
            global database
            database[self.dir.path]=cPickle.dumps(self.entries, 1)
            try:
                database.sync()
            except AttributeError:
                pass
class Dir(Base):
    def __init__(self, fp=None, module=None):
        """ """
        Base.__init__(self, module)
        if fp:
            self.entries=cPickle.load(fp)
            if type(self.entries) is not type({}):
                self.entries={}
                raise TypeError
class DirFile(Dir):
    """ """
    def __init__(self, dir, module=None):
        """ """
        self.dir=dir
        self.sconsign=os.path.join(dir.path, '.sconsign')
        try:
            fp=open(self.sconsign, 'rb')
        except IOError:
            fp=None
        try:
            Dir.__init__(self, fp, module)
        except KeyboardInterrupt:
            raise
        except:
            SCons.Warnings.warn(SCons.Warnings.CorruptSConsignWarning,
                                "Ignoring corrupt .sconsign file: %s"%self.sconsign)
        global sig_files
        sig_files.append(self)
    def write(self):
        """ """
        if self.dirty:
            temp=os.path.join(self.dir.path, '.scons%d' % os.getpid())
            try:
                file=open(temp, 'wb')
                fname=temp
            except IOError:
                try:
                    file=open(self.sconsign, 'wb')
                    fname=self.sconsign
                except IOError:
                    return
            cPickle.dump(self.entries, file, 1)
            file.close()
            if fname != self.sconsign:
                try:
                    mode=os.stat(self.sconsign)[0]
                    os.chmod(self.sconsign, 0666)
                    os.unlink(self.sconsign)
                except OSError:
                    pass
                try:
                    os.rename(fname, self.sconsign)
                except OSError:
                    open(self.sconsign, 'wb').write(open(fname, 'rb').read())
                    os.chmod(self.sconsign, mode)
            try:
                os.unlink(temp)
            except OSError:
                pass
ForDirectory=DirFile
def File(name, dbm_module=None):
    """ """
    global database
    if database is None:
        if dbm_module is None:
            import SCons.dblite
            dbm_module=SCons.dblite
        database=dbm_module.open(name, "c")
    global ForDirectory
    ForDirectory=DB
