/***************************************************************************
 *   Copyright (C) 2005 by Thomas Nagy                                     *
 *   tnagy256@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>
#include <klineedit.h>
#include <kurlrequester.h>

#include "DDataItem.h"
#include "urlpair_base.h"
#include "urldlg.h"

urldlg::urldlg( QWidget*parent, URLObject& object ) :
	KDialogBase(parent, 0, true, i18n("Edit a Link"), Ok|Cancel),
	m_object( object )
{
	m_content = new urlpair_base(this);
	setMainWidget(m_content);

	m_content->urlrequester->setURL( m_object.m_url );
	m_content->caption->setText( m_object.m_caption );

	connect(this, SIGNAL(okClicked()), this, SLOT(slotApply()));
}

urldlg::~urldlg()
{
	delete m_content;
}

void urldlg::slotApply()
{
	m_object.m_url = m_content->urlrequester->url();
	m_object.m_caption = m_content->caption->text();
}

#include "urldlg.moc"


