/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DSPELL_H
#define _DSPELL_H

#include <qobject.h>

class DDataControl;
class KSpell;
class DSpell : public QObject
{
	Q_OBJECT
	public:
		/// default constructor
		DSpell(DDataControl *parent);

		/// default destructor
		virtual ~DSpell();

		void spell();

	public slots:
		void spell_started(KSpell *);
		void spell_death();
		void spell_done(const QString&);
		void corrected(const QString&, const QString&, unsigned int);

	private:
		DDataControl *m_datacontrol;
		KSpell *m_spell;
		QString m_localtext;
};

#endif // _DSPELL_H
