/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef TEXTPROPERTIES_H
#define TEXTPROPERTIES_H

#include "TextProperties_base.h"

class DDataItem;
class QShowEvent;
class BoxURL;
class TextProperties : public TextProperties_base
{
	Q_OBJECT

	public:
		TextProperties( QWidget* parent, const char* name=0);
		~TextProperties();
		void showEvent(QShowEvent *);
		void activate();

	public slots:
		void setCurrentItem(DDataItem*, bool force=false);
		void updateItem();
		void itemChanged(int);

	private:
		DDataItem *m_lastitem;
		BoxURL* m_boxurl;
};

#endif // TEXTPROPERTIES_H
