//#include <qapplication.h>
//#include <qwidget.h>
#include <qevent.h>
#include <qtimer.h>
#include <qwidget.h>
#include <qpopupmenu.h>
#include <qcanvas.h>
#include <qobject.h>

#include <klocale.h>
#include <kdebug.h>

#include "canvasview.h"
#include "pref.h"


kfishCanvasView::kfishCanvasView( QCanvas *canvas, QWidget *parent, const char *name )
                              : QCanvasView( canvas, parent, name )
{
    installEventFilter( this );

    menu = new QPopupMenu(this);
    menu->insertItem(i18n("Configure..."), parent, SLOT( slotPreferences() ) );
    menu->insertItem(i18n("About"), parent, SLOT( slotAbout() ) );
    
    setVScrollBarMode(AlwaysOff);
    setHScrollBarMode(AlwaysOff);
}


kfishCanvasView::~kfishCanvasView()
{
}

bool kfishCanvasView::eventFilter( QObject *o, QEvent *e )
{
    (void) o;
    if ( e->type() == QEvent::Enter )
    {
        emit signalMouseOverWidget();
    }
    if ( e->type() == QEvent::Leave )
    {
        emit signalMouseNotOverWidget();
    }
    if ( e->type() == QEvent::MouseButtonPress )
    {
        QMouseEvent *b = static_cast<QMouseEvent*>(e);
        if( b->button() == Qt::RightButton )
            menu -> popup(((QMouseEvent *)e)->globalPos());        
    }
    return FALSE;
}
