/***************************************************************************
 *   Copyright (C) 2003 by Sylvain Joyeux                                  *
 *   sylvain.joyeux@m4x.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "parsers.h"
#include "../apt.h"

#include <kio/slavebase.h>
#include <klocale.h>
#include <qregexp.h>
#include <kurl.h>

namespace Parsers
{
  List::List(bool links)
    : m_links(links) {}

  /** Parses the tokens sent by PackageManager::list */
  void List::operator() (AptProtocol* slave, const QString& tag, const QString& value )
  {
    static QRegExp rx_manpage("/man/.*\\.\\d[^/]*$");

    static QStringList files;

    if (tag == "begin")
    {
      m_result_count = 0;
    }
    else if (tag == "error")
    {
      *slave << "<div class=\"error\">" + value + "</div>";
    }
    else if (tag == "file" && value != "/.")
    {
      if (m_links)
      {
        KURL url;
        if (rx_manpage.search(value) >= 0)
          url.setProtocol("man");
        else
          url.setProtocol("file");

        url.setPath(value);

        files += "<a href=\"" + url.htmlURL() + "\">" + value + "</a>";
      }
      else
      {
        files += value;
      }

      ++m_result_count;
    }
    else if (tag == "end")
    {
      files.sort();
      *slave <<
      	"<div class=\"filelist\">\n" + files.join("\n<br>") + "\n</div>\n"
        "<div class=\"footer\">" + i18n("%1 files in the package").arg(result_count()) + "</div>\n";
      files.clear();
    }
  }
}
