// GPS dump file

// File format:
// FILE HEADER
//   MAGIC
//   VERSION
//   TIME
// NETWORK HEADERS [ x 254 elements ]
//   NUMBER
//   BSSID
//   SSID
// GPS DATA [ x number of packets ]
//   NETWORK NUMBER
//   LAT
//   LON
//   ALT
//   SPD
//   FIX
//   TIME

#ifndef __GPSDUMP_H__
#define __GPSDUMP_H__

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdint.h>
#include <map.h>
#include <string>
#include "config.h"
#include "packet.h"
#include "packetracker.h"

// Sacred cows make the best hamburger.
#ifndef WORDS_BIGENDIAN
// Little endian magic
#define GPS_MAGIC 0xDEADBEEF
#else
// Big endian magic
#define GPS_MAGIC 0xEFEBADDE
#endif

// Offset of the data segment
#define DATA_OFFSET (sizeof(GPSDump::file_hdr) + (sizeof(GPSDump::net_hdr) * 254))

typedef struct {
    int32_t tv_sec;
    int32_t tv_usec;
} time_hdr;

typedef struct {
    uint32_t magic;
    uint8_t version;
    time_hdr start;
} file_hdr;

typedef struct {
    uint8_t number;
    uint8_t bssid[6];
    uint8_t ssid[SSID_SIZE];
} net_hdr;

typedef struct {
    uint8_t number;
    int16_t lat;
    int64_t lat_mant;
    int16_t lon;
    int64_t lon_mant;
    int16_t alt;
    int64_t alt_mant;
    int16_t spd;
    int64_t spd_mant;
    int16_t fix;
    time_hdr ts;
} data_pkt;

class GPSDump {
public:
    GPSDump();

    char *FetchError() { return(errstr); };

    int OpenDump(const char *in_fname);
    int CloseDump(int in_unlink);

    void AddGPS(GPSD *in_gps) { gps = in_gps; };

    int DumpPacket(packet_info *in_packinfo);

protected:
    time_hdr CurTimeHdr();
    void Float2Pair(float in_float, int16_t *primary, int64_t *mantissa);
    int FindOrHashNet(packet_info *in_packinfo);

    int num_packets;
    int num_networks;
    FILE *gpsf;
    const char *fname;
    char errstr[1024];

    map<string, int> bssid_map;
    // Our redundancy to record SSID's as they show up
    map<string, string> ssid_map;

    GPSD *gps;

};

#endif

