#ifndef __NCURSEFRONT_H__
#define __NCURSEFRONT_H__

#include "config.h"

#ifdef HAVE_LIBNCURSES

#include <stdio.h>
#include <time.h>
#include <list.h>
#include <map.h>
#include <string>

#include "packet.h"
#include "frontend.h"

// I hate libncurses headers
#include <ncurses.h>
#undef erase


const int infowidth = 10;
const int statheight = 6;

class NCurseFront : public Frontend {
public:
    NCurseFront();

    int InitDisplay(int in_decay);

    // Draw the screen
    int DrawDisplay();

    // End
    int EndDisplay();

    int WriteStatus(string status);

protected:
    void DelOldest(wireless_network *exclude);

    WINDOW *netborder, *netwin, *infoborder, *infowin,
        *statusborder, *statuswin;

};

#endif

#endif
